/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.blaster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.blaster.DestroyerShotEntity;
import net.tslat.aoa3.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class DarkDestroyer
extends BaseBlaster {
    public DarkDestroyer(double dmg, int durability, int fireDelayTicks, float energyCost) {
        super(dmg, durability, fireDelayTicks, energyCost);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_DOOM_GUN_FIRE.get();
    }

    @Override
    public void fire(ItemStack blaster, LivingEntity shooter) {
        shooter.field_70170_p.func_217376_c((Entity)new DestroyerShotEntity(shooter, this, 60));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3d hitPos, LivingEntity shooter) {
        this.doExplosions(shot, shooter, shot.func_226277_ct_(), shot.func_226278_cu_(), shot.func_226281_cx_());
    }

    @Override
    protected void doImpactEffect(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        this.doExplosions(shot, shooter, shot.func_226277_ct_(), shot.func_226278_cu_(), shot.func_226281_cx_());
    }

    private void doExplosions(BaseEnergyShot shot, LivingEntity shooter, double posX, double posY, double posZ) {
        for (double x = posX - 5.0; x <= posX + 5.0; x += 2.5) {
            for (double y = posY - 5.0; y <= posY + 5.0; y += 2.5) {
                for (double z = posZ - 5.0; z <= posZ + 5.0; z += 2.5) {
                    WorldUtil.createExplosion((Entity)shooter, shot.field_70170_p, x, y, z, 2.0f);
                }
            }
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

