/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.blaster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.blaster.LightSparkEntity;
import net.tslat.aoa3.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.constant.Resources;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public class LightSpark
extends BaseBlaster {
    public LightSpark(double dmg, int durability, int fireDelayTicks, float energyCost) {
        super(dmg, durability, fireDelayTicks, energyCost);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_SOUL_SPARK_FIRE.get();
    }

    @Override
    public void fire(ItemStack blaster, LivingEntity shooter) {
        shooter.field_70170_p.func_217376_c((Entity)new LightSparkEntity(shooter, this, 5));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (!EntityUtil.isImmuneToSpecialAttacks(target, shooter)) {
            if (shooter instanceof ServerPlayerEntity && !((ServerPlayerEntity)shooter).func_184812_l_()) {
                ServerPlayerEntity player = (ServerPlayerEntity)shooter;
                PlayerDataManager.PlayerStats stats = PlayerUtil.getAdventPlayer(player).stats();
                if (stats.getResourceValue(Resources.ENERGY) < 200.0f) {
                    PlayerUtil.notifyPlayerOfInsufficientResources(player, Resources.ENERGY, 200.0f);
                    return false;
                }
                if (stats.getResourceValue(Resources.SOUL) < 50.0f) {
                    PlayerUtil.notifyPlayerOfInsufficientResources(player, Resources.SOUL, 50.0f);
                    return false;
                }
                stats.consumeResource(Resources.ENERGY, 200.0f, false);
                stats.consumeResource(Resources.SOUL, 50.0f, false);
                Hand hand = player.func_184600_cs();
                ItemStack stack = player.func_184586_b(hand);
                if (stack.func_77973_b() != this) {
                    stack = player.func_184586_b(hand == Hand.MAIN_HAND ? Hand.OFF_HAND : Hand.MAIN_HAND);
                }
                if (stack.func_77973_b() != this) {
                    return false;
                }
                ItemUtil.damageItem(stack, shooter, hand);
            }
            target.func_70106_y();
            return true;
        }
        return false;
    }

    @Override
    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        if (!player.field_70170_p.field_72995_K && count + this.firingDelay <= 72000 && count % this.firingDelay == 0) {
            if (this.getFiringSound() != null) {
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), this.getFiringSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            this.fire(stack, player);
            ((PlayerEntity)player).func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
    }

    @Override
    public void func_77615_a(ItemStack stack, World world, LivingEntity player, int useTicksRemaining) {
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.damage.specImmune", LocaleUtil.ItemDescriptionType.HARMFUL, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.ammo.resource", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, "200", LocaleUtil.getLocaleString("resources.energy.name")));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.ammo.resource", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, "50", LocaleUtil.getLocaleString("resources.soul.name")));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.blaster.fire", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.blaster.slowing", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.blaster.effect", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.gun.firingSpeed", LocaleUtil.ItemDescriptionType.NEUTRAL, Double.toString((double)(2000 / this.firingDelay) / 100.0)));
    }
}

