/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.blaster;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.blaster.ToxicShotEntity;
import net.tslat.aoa3.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;

public class ToxicTerrorizer
extends BaseBlaster {
    public ToxicTerrorizer(double dmg, int durability, int fireDelayTicks, float energyCost) {
        super(dmg, durability, fireDelayTicks, energyCost);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_MAGIC_GUN_FIRE.get();
    }

    @Override
    public void fire(ItemStack blaster, LivingEntity shooter) {
        shooter.field_70170_p.func_217376_c((Entity)new ToxicShotEntity(shooter, this, 60));
        shooter.field_70170_p.func_217376_c((Entity)new ToxicShotEntity(shooter, this, 60, -0.05f, -0.05f, 0.0f));
        shooter.field_70170_p.func_217376_c((Entity)new ToxicShotEntity(shooter, this, 60, 0.05f, -0.05f, 0.0f));
        shooter.field_70170_p.func_217376_c((Entity)new ToxicShotEntity(shooter, this, 60, 0.0f, -0.05f, -0.05f));
        shooter.field_70170_p.func_217376_c((Entity)new ToxicShotEntity(shooter, this, 60, 0.0f, -0.05f, 0.05f));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (target instanceof LivingEntity) {
            EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76436_u, 185).level(2));
        }
        return false;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.damage.poison", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

