/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.bow;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.util.LocaleUtil;

public class BaseBow
extends BowItem {
    protected float drawSpeedMultiplier;
    protected double dmg;

    public BaseBow(double damage, float drawSpeedMultiplier, int durability) {
        super(new Item.Properties().func_200916_a(AoAItemGroups.BOWS).func_200918_c(durability));
        this.dmg = damage;
        this.drawSpeedMultiplier = drawSpeedMultiplier;
        this.func_185043_a(new ResourceLocation("pull"), (stack, world, entity) -> {
            if (entity == null) {
                return 0.0f;
            }
            return !(entity.func_184607_cu().func_77973_b() instanceof BaseBow) ? 0.0f : this.getDrawSpeedMultiplier() * (float)(stack.func_77988_m() - entity.func_184605_cv()) / 20.0f;
        });
        this.func_185043_a(new ResourceLocation("pulling"), (stack, world, entity) -> entity != null && entity.func_184587_cr() && entity.func_184607_cu() == stack ? 1.0f : 0.0f);
    }

    public double getDamage() {
        return this.dmg * (double)((Boolean)AoAConfig.COMMON.hardcoreMode.get() != false ? 1.25f : 1.0f);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldStack;
        boolean hasAmmo = !this.findAmmo(player, heldStack = player.func_184586_b(hand), player.func_184812_l_()).func_190926_b();
        ActionResult arrowNockEventResult = ForgeEventFactory.onArrowNock((ItemStack)heldStack, (World)world, (PlayerEntity)player, (Hand)hand, (boolean)hasAmmo);
        if (arrowNockEventResult != null) {
            return arrowNockEventResult;
        }
        if (!player.func_184812_l_() && !hasAmmo) {
            return ActionResult.func_226251_d_((Object)heldStack);
        }
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)heldStack);
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity shooter, int timeLeft) {
        if (!(shooter instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity pl = (PlayerEntity)shooter;
        boolean infiniteAmmo = pl.func_184812_l_() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
        ItemStack ammoStack = this.findAmmo(pl, stack, infiniteAmmo);
        int charge = (int)((float)(this.func_77626_a(stack) - timeLeft) * this.getDrawSpeedMultiplier());
        if ((charge = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)world, (PlayerEntity)pl, (int)charge, (!ammoStack.func_190926_b() || infiniteAmmo ? 1 : 0) != 0)) < 0) {
            return;
        }
        if (!ammoStack.func_190926_b() || infiniteAmmo) {
            float velocity;
            if (ammoStack.func_190926_b()) {
                ammoStack = new ItemStack((IItemProvider)Items.field_151032_g);
            }
            if ((double)(velocity = BaseBow.func_185059_b((int)charge)) >= 0.1) {
                if (!world.field_72995_K) {
                    CustomArrowEntity arrow = this.makeArrow((LivingEntity)pl, stack, ammoStack, velocity, !infiniteAmmo);
                    arrow = this.doArrowMods(arrow, shooter, ammoStack, timeLeft);
                    world.func_217376_c((Entity)arrow);
                }
                world.func_184148_a(null, pl.func_226277_ct_(), pl.func_226278_cu_(), pl.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + velocity * 0.5f);
                if (!infiniteAmmo && !pl.field_71075_bZ.field_75098_d) {
                    ammoStack.func_190918_g(1);
                    if (ammoStack.func_190926_b()) {
                        pl.field_71071_by.func_184437_d(ammoStack);
                    }
                }
                pl.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            }
        }
    }

    protected ItemStack findAmmo(PlayerEntity shooter, ItemStack bowStack, boolean infiniteAmmo) {
        return shooter.func_213356_f(bowStack);
    }

    protected CustomArrowEntity makeArrow(LivingEntity shooter, ItemStack bowStack, ItemStack ammoStack, float velocity, boolean consumeAmmo) {
        ArrowItem arrowItem = (ArrowItem)(ammoStack.func_77973_b() instanceof ArrowItem ? ammoStack.func_77973_b() : Items.field_151032_g);
        CustomArrowEntity arrow = CustomArrowEntity.fromArrow(arrowItem.func_200887_a(shooter.field_70170_p, ammoStack, shooter), this, shooter, this.getDamage());
        arrow.func_184547_a((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, velocity * 3.0f, 1.0f);
        if (velocity == 1.0f) {
            arrow.func_70243_d(true);
        }
        int powerEnchant = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)bowStack);
        int punchEnchant = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)bowStack);
        if (powerEnchant > 0) {
            arrow.func_70239_b(arrow.func_70242_d() + (double)powerEnchant * 1.5 + 1.0);
        }
        if (punchEnchant > 0) {
            arrow.func_70240_a(punchEnchant);
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)bowStack) > 0) {
            arrow.func_70015_d(100);
        }
        bowStack.func_222118_a(1, shooter, firingEntity -> firingEntity.func_213334_d(shooter.func_184600_cs()));
        if (!consumeAmmo || shooter instanceof PlayerEntity && ((PlayerEntity)shooter).func_184812_l_() && (ammoStack.func_77973_b() == Items.field_185166_h || ammoStack.func_77973_b() == Items.field_185167_i)) {
            arrow.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
        }
        return arrow;
    }

    public float getDrawSpeedMultiplier() {
        return this.drawSpeedMultiplier;
    }

    public CustomArrowEntity doArrowMods(CustomArrowEntity arrow, LivingEntity shooter, ItemStack ammoStack, int useTicksRemaining) {
        return arrow;
    }

    public void onEntityHit(CustomArrowEntity arrow, Entity target, Entity shooter, double damage, float drawStrength) {
    }

    public void onBlockHit(CustomArrowEntity arrow, BlockRayTraceResult rayTrace, Entity shooter) {
    }

    public void onArrowTick(CustomArrowEntity arrow, Entity shooter) {
    }

    public double getArrowDamage(CustomArrowEntity arrow, Entity target, double currentDamage, float drawStrength, boolean isCritical) {
        double damage = currentDamage * 0.5 * (double)(drawStrength / 3.0f);
        if (isCritical) {
            damage += damage + damage * (double)0.35f * field_77697_d.nextGaussian();
        }
        return damage;
    }

    public int func_77619_b() {
        return 8;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(1, LocaleUtil.getFormattedItemDescriptionText("items.description.damage.arrows", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, Double.toString(this.getDamage())));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.bow.drawSpeed", LocaleUtil.ItemDescriptionType.NEUTRAL, Double.toString((double)((int)(72000.0f / this.getDrawSpeedMultiplier()) / 720) / 100.0)));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.ammo.item", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, LocaleUtil.getItemName((IItemProvider)Items.field_151032_g)));
    }
}

