/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.bow;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.entity.projectile.arrow.PopShotEntity;
import net.tslat.aoa3.item.weapon.bow.BaseBow;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class Slingshot
extends BaseBow {
    public static final Predicate<ItemStack> AMMO_PREDICATE = stack -> stack.func_77973_b() == AoAItems.POP_SHOT.get() || stack.func_77973_b() == Items.field_151145_ak;
    private final float drawSpeedMultiplier;
    private final double dmg;

    public Slingshot(double damage, float drawSpeedMultiplier, int durability) {
        super(damage, drawSpeedMultiplier, durability);
        this.drawSpeedMultiplier = drawSpeedMultiplier;
        this.dmg = damage;
    }

    @Override
    public void onEntityHit(CustomArrowEntity shot, Entity target, Entity shooter, double damage, float drawStrength) {
        if (shot instanceof PopShotEntity && ((PopShotEntity)shot).isExplosive) {
            WorldUtil.createExplosion(shooter, shot.field_70170_p, (Entity)shot, 1.0f);
        }
        shot.func_70106_y();
    }

    @Override
    public void onBlockHit(CustomArrowEntity shot, BlockRayTraceResult rayTrace, Entity shooter) {
        if (shot instanceof PopShotEntity && ((PopShotEntity)shot).isExplosive) {
            WorldUtil.createExplosion(shooter, shot.field_70170_p, (Entity)shot, 1.0f);
        }
        shot.func_70106_y();
    }

    public Predicate<ItemStack> func_220004_b() {
        return AMMO_PREDICATE;
    }

    @Override
    public double getArrowDamage(CustomArrowEntity arrow, Entity target, double currentDamage, float drawStrength, boolean isCritical) {
        double damage = currentDamage * (double)(drawStrength / 2.0f);
        if (isCritical) {
            damage += damage + damage * (double)0.35f * field_77697_d.nextGaussian();
        }
        return damage;
    }

    @Override
    public CustomArrowEntity doArrowMods(CustomArrowEntity arrow, LivingEntity shooter, ItemStack ammoStack, int useTicksRemaining) {
        PopShotEntity popShot = new PopShotEntity(arrow.field_70170_p, this, shooter, this.dmg, ammoStack.func_77973_b() instanceof ArrowItem);
        popShot.func_184547_a((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, BowItem.func_185059_b((int)((int)(72000.0f / this.drawSpeedMultiplier - (float)useTicksRemaining))) * 2.0f, 1.0f);
        return popShot;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(1, LocaleUtil.getFormattedItemDescriptionText("items.description.damage.arrows", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, Double.toString(this.dmg)));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.bow.drawSpeed", LocaleUtil.ItemDescriptionType.NEUTRAL, Double.toString((double)(72000.0f / this.drawSpeedMultiplier / 720.0f) / 100.0)));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.ammo.item", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, LocaleUtil.getItemName((IItemProvider)AoAItems.POP_SHOT.get()) + "/" + LocaleUtil.getItemName((IItemProvider)Items.field_151145_ak)));
    }
}

