/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.cannon;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.common.registration.AoAWeapons;
import net.tslat.aoa3.entity.projectile.cannon.FloroRPGEntity;
import net.tslat.aoa3.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.item.weapon.cannon.BaseCannon;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;

public class FloroRPG
extends BaseCannon {
    private double dmg;
    private int firingDelay;

    public FloroRPG(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
        this.dmg = dmg;
        this.firingDelay = firingDelayTicks;
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_RPG_FIRE.get();
    }

    @Override
    public BaseBullet findAndConsumeAmmo(PlayerEntity player, ItemStack gunStack, Hand hand) {
        if (ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)AoAWeapons.GRENADE.get()), true, 1 + EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)gunStack))) {
            return new FloroRPGEntity((LivingEntity)player, (BaseGun)gunStack.func_77973_b(), hand, 120, 0);
        }
        return null;
    }

    @Override
    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target != null) {
            if (target instanceof LivingEntity) {
                bulletDmgMultiplier = (float)((double)bulletDmgMultiplier * (1.0 + ((LivingEntity)target).func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e() * 6.66 / 100.0));
            }
            if (DamageUtil.dealGunDamage(target, shooter, bullet, (float)this.dmg * bulletDmgMultiplier) && shooter instanceof ServerPlayerEntity && target instanceof LivingEntity && ((LivingEntity)target).func_110143_aJ() == 0.0f && target.field_70160_al && target.field_70170_p.func_175623_d(target.func_180425_c().func_177977_b()) && target.field_70170_p.func_175623_d(target.func_180425_c().func_177979_c(2))) {
                AdvancementUtil.completeAdvancement((ServerPlayerEntity)shooter, new ResourceLocation("aoa3", "overworld/surface_to_air"), "rpg_air_kill");
            }
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(1, LocaleUtil.getFormattedItemDescriptionText("items.description.damage.gun", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, NumberUtil.roundToNthDecimalPlace((float)this.dmg, 2)));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.cannon.damage", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.gun.firingSpeed", LocaleUtil.ItemDescriptionType.NEUTRAL, Double.toString((double)(2000 / this.firingDelay) / 100.0)));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.ammo.item", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, LocaleUtil.getItemName((IItemProvider)AoAWeapons.GRENADE.get())));
    }
}

