/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.crossbow;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ICrossbowUser;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.entity.projectile.arrow.CustomArrowEntity;
import net.tslat.aoa3.util.LocaleUtil;

public class BaseCrossbow
extends CrossbowItem {
    protected double damage;

    public BaseCrossbow(double damage, int durability) {
        super(new Item.Properties().func_200916_a(AoAItemGroups.CROSSBOWS).func_200918_c(durability));
        this.damage = damage;
    }

    public double getDamage() {
        return this.damage * (double)((Boolean)AoAConfig.COMMON.hardcoreMode.get() != false ? 1.25f : 1.0f);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack crossbowStack = player.func_184586_b(hand);
        if (BaseCrossbow.func_220012_d((ItemStack)crossbowStack)) {
            this.fireProjectiles((LivingEntity)player, hand, crossbowStack, this.getShotVelocity(crossbowStack), 1.0f);
            BaseCrossbow.func_220011_a((ItemStack)crossbowStack, (boolean)false);
            return ActionResult.func_226249_b_((Object)crossbowStack);
        }
        if (!this.findAmmo(crossbowStack, (LivingEntity)player, player.func_184812_l_()).func_190926_b()) {
            if (!BaseCrossbow.func_220012_d((ItemStack)crossbowStack)) {
                this.field_220034_c = false;
                this.field_220035_d = false;
                player.func_184598_c(hand);
            }
            return ActionResult.func_226249_b_((Object)crossbowStack);
        }
        return ActionResult.func_226251_d_((Object)crossbowStack);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return super.func_77661_b(stack);
    }

    public void func_219972_a(World world, LivingEntity shooter, ItemStack stack, int count) {
        if (!world.field_72995_K) {
            int quickCharge = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222193_H, (ItemStack)stack);
            SoundEvent chargeSound = this.getChargeSound(quickCharge);
            SoundEvent middleChargeSound = quickCharge == 0 ? SoundEvents.field_219611_bC : null;
            float chargePercent = (float)(stack.func_77988_m() - count) / (float)BaseCrossbow.func_220026_e((ItemStack)stack);
            if (chargePercent < 0.2f) {
                this.field_220034_c = false;
                this.field_220035_d = false;
            }
            if (chargePercent >= 0.2f && !this.field_220034_c) {
                this.field_220034_c = true;
                world.func_184148_a(null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), chargeSound, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            if (chargePercent >= 0.5f && middleChargeSound != null && !this.field_220035_d) {
                this.field_220035_d = true;
                world.func_184148_a(null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), middleChargeSound, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public void func_77615_a(ItemStack crossbowStack, World world, LivingEntity shooter, int timeLeft) {
        int useTicks = this.func_77626_a(crossbowStack) - timeLeft;
        float charge = this.getCharge(crossbowStack, useTicks);
        if (charge >= 1.0f && !BaseCrossbow.func_220012_d((ItemStack)crossbowStack) && this.func_220021_a(shooter, crossbowStack)) {
            BaseCrossbow.func_220011_a((ItemStack)crossbowStack, (boolean)true);
            world.func_184148_a(null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_219610_bB, shooter instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
        }
    }

    protected ItemStack findAmmo(ItemStack crossbowStack, LivingEntity player, boolean infiniteAmmo) {
        return player.func_213356_f(crossbowStack);
    }

    protected boolean func_220021_a(LivingEntity user, ItemStack crossbowStack) {
        int multishot = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222192_G, (ItemStack)crossbowStack);
        boolean infiniteAmmo = user instanceof PlayerEntity && ((PlayerEntity)user).func_184812_l_();
        ItemStack ammoStack = this.findAmmo(crossbowStack, user, infiniteAmmo);
        ItemStack ammoStackCopy = ammoStack.func_77946_l();
        for (int i = 0; i < 1 + multishot * 2; ++i) {
            if (i > 0) {
                ammoStack = ammoStackCopy.func_77946_l();
            }
            if (ammoStack.func_190926_b() && infiniteAmmo) {
                ammoStack = new ItemStack((IItemProvider)Items.field_151032_g);
                ammoStackCopy = ammoStack.func_77946_l();
            }
            if (this.chargeShot(user, crossbowStack, ammoStack, i > 0, infiniteAmmo)) continue;
            return false;
        }
        return true;
    }

    protected boolean chargeShot(LivingEntity shooter, ItemStack crossbowStack, ItemStack ammoStack, boolean isMultishotProjectile, boolean infiniteAmmo) {
        ItemStack itemstack;
        boolean canUseAmmo;
        if (ammoStack.func_190926_b()) {
            return false;
        }
        boolean bl = canUseAmmo = infiniteAmmo && ammoStack.func_77973_b() instanceof ArrowItem;
        if (!(canUseAmmo || infiniteAmmo || isMultishotProjectile)) {
            itemstack = ammoStack.func_77979_a(1);
            if (ammoStack.func_190926_b() && shooter instanceof PlayerEntity) {
                ((PlayerEntity)shooter).field_71071_by.func_184437_d(ammoStack);
            }
        } else {
            itemstack = ammoStack.func_77946_l();
        }
        this.func_220029_b(crossbowStack, itemstack);
        return true;
    }

    protected void func_220029_b(ItemStack crossbow, ItemStack projectile) {
        CompoundNBT tag = crossbow.func_196082_o();
        ListNBT projectilesNbt = tag.func_150297_b("ChargedProjectiles", 9) ? tag.func_150295_c("ChargedProjectiles", 10) : new ListNBT();
        CompoundNBT projectileTag = new CompoundNBT();
        projectile.func_77955_b(projectileTag);
        projectilesNbt.add((Object)projectileTag);
        tag.func_218657_a("ChargedProjectiles", (INBT)projectilesNbt);
    }

    protected void fireProjectiles(LivingEntity shooter, Hand hand, ItemStack crossbowStack, float baseVelocity, float baseInaccuracy) {
        List<ItemStack> projectiles = this.func_220018_j(crossbowStack);
        if (projectiles.isEmpty()) {
            return;
        }
        float[] soundPitches = this.getRandomSoundPitches(shooter.func_70681_au(), projectiles.size());
        boolean creativeMode = shooter instanceof PlayerEntity && ((PlayerEntity)shooter).func_184812_l_();
        float spreadModifier = -10.0f;
        this.fireProjectile(shooter, hand, crossbowStack, projectiles.get(0), soundPitches[0], creativeMode, baseVelocity, baseInaccuracy, 0.0f);
        for (int i = 1; i < projectiles.size(); ++i) {
            ItemStack projectile = projectiles.get(i);
            this.fireProjectile(shooter, hand, crossbowStack, projectile, soundPitches[i], creativeMode, baseVelocity, baseInaccuracy, spreadModifier);
            spreadModifier = spreadModifier < 0.0f ? spreadModifier * -1.0f : spreadModifier / -2.0f;
        }
        if (shooter instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)shooter;
            CriteriaTriggers.field_215099_F.func_215111_a(player, crossbowStack);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)crossbowStack.func_77973_b()));
        }
        this.func_220027_k(crossbowStack);
    }

    protected void fireProjectile(LivingEntity shooter, Hand hand, ItemStack crossbowStack, ItemStack projectileStack, float soundPitch, boolean isCreative, float velocity, float inaccuracy, float projectileAngle) {
        World world = shooter.func_130014_f_();
        if (!world.field_72995_K) {
            CustomArrowEntity projectile;
            boolean isFirework;
            boolean bl = isFirework = projectileStack.func_77973_b() == Items.field_196152_dE;
            if (isFirework) {
                projectile = new FireworkRocketEntity(world, projectileStack, shooter.func_226277_ct_(), shooter.func_226280_cw_() - (double)0.15f, shooter.func_226281_cx_(), true);
            } else {
                projectile = this.createArrow(shooter, crossbowStack, projectileStack);
                if (isCreative || projectileAngle != 0.0f) {
                    ((AbstractArrowEntity)projectile).field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                }
            }
            if (shooter instanceof ICrossbowUser) {
                ICrossbowUser crossbowUser = (ICrossbowUser)shooter;
                crossbowUser.func_213670_a(crossbowUser.func_70638_az(), crossbowStack, (IProjectile)projectile, projectileAngle);
            } else {
                Vec3d vecUp = shooter.func_213286_i(1.0f);
                Quaternion angle = new Quaternion(new Vector3f(vecUp), projectileAngle, true);
                Vector3f lookVec = new Vector3f(shooter.func_70676_i(1.0f));
                lookVec.func_214905_a(angle);
                projectile.func_70186_c(lookVec.func_195899_a(), lookVec.func_195900_b(), lookVec.func_195902_c(), velocity, inaccuracy);
            }
            if (projectile instanceof CustomArrowEntity) {
                this.doArrowMods(projectile, (Entity)shooter, 0);
            }
            world.func_217376_c((Entity)projectile);
            crossbowStack.func_222118_a(isFirework ? 3 : 1, shooter, user -> user.func_213334_d(hand));
            world.func_184148_a(null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_219616_bH, SoundCategory.PLAYERS, 1.0f, soundPitch);
        }
    }

    protected CustomArrowEntity createArrow(LivingEntity shooter, ItemStack crossbowStack, ItemStack ammoStack) {
        ArrowItem arrowItem = (ArrowItem)(ammoStack.func_77973_b() instanceof ArrowItem ? ammoStack.func_77973_b() : Items.field_151032_g);
        CustomArrowEntity arrow = CustomArrowEntity.fromArrow(arrowItem.func_200887_a(shooter.field_70170_p, ammoStack, shooter), this, shooter, this.getDamage());
        if (shooter instanceof PlayerEntity) {
            arrow.func_70243_d(true);
        }
        arrow.func_213869_a(SoundEvents.field_219609_bA);
        arrow.func_213865_o(true);
        int piercing = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_222194_I, (ItemStack)crossbowStack);
        if (piercing > 0) {
            arrow.func_213872_b((byte)piercing);
        }
        return arrow;
    }

    protected float getShotVelocity(ItemStack crossbowStack) {
        return crossbowStack.func_77973_b() instanceof BaseCrossbow && this.func_220019_a(crossbowStack, Items.field_196152_dE) ? 1.6f : 3.15f;
    }

    protected boolean func_220019_a(ItemStack crossbowStack, Item projectileItem) {
        return this.func_220018_j(crossbowStack).stream().anyMatch(stack -> stack.func_77973_b() == projectileItem);
    }

    protected float getCharge(ItemStack crossbowStack, int useTime) {
        return Math.min((float)useTime / (float)BaseCrossbow.func_220026_e((ItemStack)crossbowStack), 1.0f);
    }

    protected List<ItemStack> func_220018_j(ItemStack crossbowStack) {
        ArrayList projectiles = Lists.newArrayList();
        CompoundNBT tag = crossbowStack.func_77978_p();
        if (tag != null && tag.func_150297_b("ChargedProjectiles", 9)) {
            ListNBT projectileNbt = tag.func_150295_c("ChargedProjectiles", 10);
            for (int i = 0; i < projectileNbt.size(); ++i) {
                projectiles.add(ItemStack.func_199557_a((CompoundNBT)projectileNbt.func_150305_b(i)));
            }
        }
        return projectiles;
    }

    protected void func_220027_k(ItemStack crossbowStack) {
        CompoundNBT tag = crossbowStack.func_77978_p();
        if (tag != null) {
            ListNBT projectilesNbt = tag.func_150295_c("ChargedProjectiles", 9);
            projectilesNbt.clear();
            tag.func_218657_a("ChargedProjectiles", (INBT)projectilesNbt);
        }
    }

    protected float[] getRandomSoundPitches(Random rand, int amount) {
        float[] pitches = new float[amount];
        for (int i = 0; i < amount; ++i) {
            pitches[i] = 1.0f / (rand.nextFloat() * 0.5f + 1.8f) + (rand.nextBoolean() ? 0.63f : 0.43f);
        }
        return pitches;
    }

    protected SoundEvent getChargeSound(int quickCharge) {
        switch (quickCharge) {
            case 1: {
                return SoundEvents.field_219613_bE;
            }
            case 2: {
                return SoundEvents.field_219614_bF;
            }
            case 3: {
                return SoundEvents.field_219615_bG;
            }
        }
        return SoundEvents.field_219612_bD;
    }

    public boolean func_219970_i(ItemStack stack) {
        return true;
    }

    public void doArrowMods(CustomArrowEntity arrow, Entity shooter, int useTicksRemaining) {
    }

    public void onEntityHit(CustomArrowEntity arrow, Entity target, Entity shooter, double damage, float drawStrength) {
    }

    public void onBlockHit(CustomArrowEntity arrow, BlockRayTraceResult rayTrace, Entity shooter) {
    }

    public void onArrowTick(CustomArrowEntity arrow, Entity shooter) {
    }

    public double getArrowDamage(CustomArrowEntity arrow, Entity target, double currentDamage, float drawStrength, boolean isCritical) {
        double damage = currentDamage * 0.5 * (double)(drawStrength / 3.0f);
        if (isCritical) {
            damage += damage + damage * (double)0.35f * field_77697_d.nextGaussian();
        }
        return damage;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(1, LocaleUtil.getFormattedItemDescriptionText("items.description.damage.arrows", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, Double.toString(this.getDamage())));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.ammo.item", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, LocaleUtil.getItemName((IItemProvider)Items.field_151032_g)));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

