/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.greatblade;

import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.item.LongReachItem;
import net.tslat.aoa3.util.ItemUtil;

public class BaseGreatblade
extends Item
implements LongReachItem {
    protected final AttributeModifier ATTACK_REACH_MODIFIER = new AttributeModifier(UUID.fromString("93bb7485-ce86-4e78-ab50-26f53d78ad9d"), "AoAGreatbladeReach", (double)(this.getReach() - 3.5f), AttributeModifier.Operation.ADDITION);
    private final double baseDamage;
    private final double attackSpeed;

    public BaseGreatblade(double baseDmg, double attackSpeed, int durability) {
        this(baseDmg, attackSpeed, new Item.Properties().func_200918_c(durability).func_200916_a(AoAItemGroups.GREATBLADES).addToolType(ToolType.get((String)"sword"), 4));
    }

    public BaseGreatblade(double baseDmg, double attackSpeed, Item.Properties properties) {
        super(properties);
        this.baseDamage = baseDmg;
        this.attackSpeed = attackSpeed;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        return true;
    }

    public int func_77619_b() {
        return 8;
    }

    @Override
    public float getReach() {
        return 5.0f;
    }

    public double getAttackDamage() {
        return this.baseDamage * (double)((Boolean)AoAConfig.COMMON.hardcoreMode.get() != false ? 1.25f : 1.0f);
    }

    public double getAttackSpeed() {
        return this.attackSpeed;
    }

    protected double getDamageForAttack(ItemStack stack, Entity target, LivingEntity attacker, double baseDmg) {
        return this.getAttackDamage();
    }

    @Override
    public boolean hitEntity(ItemStack stack, Entity target, LivingEntity attacker, float dmg) {
        float damageDealt = 0.0f;
        if (dmg < 0.0f) {
            dmg = (float)this.getDamageForAttack(stack, target, attacker, this.getAttackDamage()) + 1.0f;
        }
        if (attacker instanceof PlayerEntity) {
            if (target instanceof FireballEntity) {
                if (target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)), dmg)) {
                    damageDealt = dmg;
                }
            } else {
                EffectInstance str = attacker.func_70660_b(Effects.field_76420_g);
                EffectInstance weak = attacker.func_70660_b(Effects.field_76437_t);
                float targetHealth = 0.0f;
                if (target instanceof LivingEntity) {
                    targetHealth = ((LivingEntity)target).func_110143_aJ();
                }
                if (str != null) {
                    dmg += (float)((str.func_76458_c() + 1) * 3);
                }
                if (weak != null) {
                    dmg -= (float)((weak.func_76458_c() + 1) * 4);
                }
                float cooldownMultiplier = ((PlayerEntity)attacker).func_184825_o(0.0f);
                int severModifier = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.SEVER.get()), (ItemStack)stack);
                float finalDmg = (dmg + (float)severModifier * 1.5f) * (cooldownMultiplier + 0.01f);
                if (target instanceof EnderDragonEntity ? ((EnderDragonEntity)target).func_213404_dT()[0].func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)), finalDmg) : target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)), finalDmg)) {
                    if (attacker.field_70170_p instanceof ServerWorld) {
                        if ((double)cooldownMultiplier >= 1.0) {
                            double d0 = -MathHelper.func_76126_a((float)(attacker.field_70177_z * ((float)Math.PI / 180)));
                            double d1 = MathHelper.func_76134_b((float)(attacker.field_70177_z * ((float)Math.PI / 180)));
                            ((ServerWorld)attacker.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197603_N, target.func_226277_ct_() + d0, target.func_226278_cu_() + (double)target.func_213302_cg() * 0.5, target.func_226281_cx_() + d1, 0, d0, 0.0, d1, 0.0);
                            attacker.field_70170_p.func_184148_a(null, attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_(), SoundEvents.field_187730_dW, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        }
                        int hearts = 0;
                        if (target instanceof LivingEntity) {
                            damageDealt = targetHealth - ((LivingEntity)target).func_110143_aJ();
                            hearts = (int)(damageDealt / 2.0f);
                        } else {
                            damageDealt = dmg;
                        }
                        if (hearts > 0) {
                            ((ServerWorld)attacker.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, target.func_226277_ct_(), target.func_226278_cu_() + (double)(target.func_213302_cg() * 0.5f), target.func_226281_cx_(), hearts, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    ItemUtil.damageItem(stack, attacker, 1, EquipmentSlotType.MAINHAND);
                }
            }
        } else {
            double health;
            if (dmg < 0.0f) {
                dmg = (float)this.getDamageForAttack(stack, target, attacker, this.getAttackDamage());
            }
            EffectInstance str = attacker.func_70660_b(Effects.field_76420_g);
            EffectInstance weak = attacker.func_70660_b(Effects.field_76437_t);
            double d = health = target instanceof LivingEntity ? (double)((LivingEntity)target).func_110143_aJ() : 0.0;
            if (str != null) {
                dmg += (float)((str.func_76458_c() + 1) * 3);
            }
            if (weak != null) {
                dmg -= (float)((weak.func_76458_c() + 1) * 4);
            }
            if (target.func_70097_a(DamageSource.func_76358_a((LivingEntity)attacker), dmg += (float)EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.SEVER.get()), (ItemStack)stack)) && health > 0.0) {
                damageDealt = (float)health - ((LivingEntity)target).func_110143_aJ();
            }
        }
        if (damageDealt > 0.0f) {
            this.doMeleeEffect(stack, attacker, target, damageDealt);
            return true;
        }
        return false;
    }

    protected void doMeleeEffect(ItemStack stack, LivingEntity attacker, Entity target, float dmgDealt) {
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        Material material = state.func_185904_a();
        if (material == Material.field_151569_G) {
            return 25.0f;
        }
        if (material == Material.field_151585_k || material == Material.field_151582_l || material == Material.field_151589_v || material == Material.field_151584_j || material == Material.field_151572_C) {
            return 2.0f;
        }
        return 1.0f;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity user) {
        if (!world.field_72995_K && (double)state.func_185887_b((IBlockReader)world, pos) != 0.0) {
            ItemUtil.damageItem(stack, user, 1, EquipmentSlotType.MAINHAND);
        }
        return true;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return false;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)PlayerEntity.REACH_DISTANCE.func_111108_a(), (Object)this.ATTACK_REACH_MODIFIER);
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", this.getAttackDamage(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.getAttackSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

