/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.greatblade;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.item.weapon.greatblade.BaseGreatblade;
import net.tslat.aoa3.util.LocaleUtil;

public class LunarGreatblade
extends BaseGreatblade {
    private final double baseDmg = this.getAttackDamage() - this.getAttackDamage() / 2.0;
    private final double maxDmg = this.getAttackDamage() + this.getAttackDamage() / 2.0;

    public LunarGreatblade() {
        super(25.0, (double)-3.24f, 1850);
    }

    @Override
    protected double getDamageForAttack(ItemStack stack, Entity target, LivingEntity attacker, double baseDmg) {
        return (float)((double)field_77697_d.nextFloat() * (this.maxDmg - baseDmg) + baseDmg) - 1.0f;
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)PlayerEntity.REACH_DISTANCE.func_111108_a(), (Object)this.ATTACK_REACH_MODIFIER);
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 0.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.getAttackSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.damage.random", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, Double.toString(this.baseDmg), Double.toString(this.maxDmg)));
    }
}

