/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.greatblade;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.item.weapon.greatblade.BaseGreatblade;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.constant.Resources;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public class PlutonScythe
extends BaseGreatblade {
    private static final AttributeModifier LUCK_BUFF = new AttributeModifier(UUID.fromString("e446949b-1792-4a66-8f83-5037d6dcce9b"), "AoALuxonScytheLuckBuff", 2.0, AttributeModifier.Operation.ADDITION);

    public PlutonScythe() {
        super(19.0, -3.0, 175);
    }

    @Override
    protected void doMeleeEffect(ItemStack stack, LivingEntity attacker, Entity target, float dmgDealt) {
        float damagePercent;
        PlayerDataManager.PlayerStats targetStats;
        float soulAmount;
        if (!attacker.field_70170_p.field_72995_K && (soulAmount = ((targetStats = target instanceof ServerPlayerEntity ? PlayerUtil.getAdventPlayer((ServerPlayerEntity)target).stats() : null) != null ? Math.min(5.0f, targetStats.getResourceValue(Resources.SOUL)) : 5.0f) * (damagePercent = dmgDealt / (float)this.getAttackDamage())) > 0.0f) {
            if (targetStats != null && !targetStats.consumeResource(Resources.SOUL, soulAmount, true)) {
                return;
            }
            if (attacker instanceof ServerPlayerEntity) {
                PlayerUtil.addResourceToPlayer((ServerPlayerEntity)attacker, Resources.SOUL, soulAmount);
            }
        }
    }

    @Override
    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        Multimap<String, AttributeModifier> multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_188792_h.func_111108_a(), (Object)LUCK_BUFF);
        }
        return multimap;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.scythe", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new String[0]));
    }
}

