/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.gun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.entity.projectile.gun.LimoniteBulletEntity;
import net.tslat.aoa3.entity.projectile.thrown.GrenadeEntity;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;

public class Baronator
extends BaseGun {
    public Baronator(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(AoAItemGroups.GUNS, dmg, durability, firingDelayTicks, recoil);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_REVOLVER_FIRE.get();
    }

    @Override
    public BaseBullet findAndConsumeAmmo(PlayerEntity player, ItemStack gunStack, Hand hand) {
        if (ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)AoAItems.LIMONITE_BULLET.get()), true, 1 + EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)gunStack))) {
            if (!player.field_70170_p.field_72995_K && RandomUtil.oneInNChance(5)) {
                player.field_70170_p.func_217376_c((Entity)new GrenadeEntity((LivingEntity)player, (BaseGun)gunStack.func_77973_b(), hand, 120, 0));
            }
            return new LimoniteBulletEntity((LivingEntity)player, (BaseGun)gunStack.func_77973_b(), hand, 120, 0);
        }
        return null;
    }

    @Override
    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (!(bullet instanceof GrenadeEntity)) {
            super.doImpactDamage(target, shooter, bullet, bulletDmgMultiplier);
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

