/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.gun;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.GunRecoilPacket;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.enchantment.BraceEnchantment;
import net.tslat.aoa3.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.entity.projectile.gun.LimoniteBulletEntity;
import net.tslat.aoa3.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.item.weapon.thrown.BaseThrownWeapon;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;

public abstract class BaseGun
extends Item {
    protected static final UUID ATTACK_SPEED_MAINHAND = UUID.fromString("99fdc256-279e-4c8e-b1c6-9209571f134e");
    protected static final UUID ATTACK_SPEED_OFFHAND = UUID.fromString("63f030a6-7269-444d-b26c-ae3514b36e1b");
    protected final double dmg;
    protected final int firingDelay;
    protected final float recoil;
    protected double holsterMod;

    public BaseGun(Item.Properties properties, double dmg, int fireDelayTicks, float recoil) {
        super(properties);
        this.dmg = dmg;
        this.firingDelay = fireDelayTicks;
        this.recoil = recoil;
        this.holsterMod = this.getDamage() == 0.0 ? 0.85 : (this instanceof BaseThrownWeapon ? 0.5 : 0.8 + 0.17 * Math.min(20.0 / (double)this.getFiringDelay() * this.getDamage() / 55.0, 0.85));
    }

    public BaseGun(ItemGroup itemGroup, double dmg, int durability, int fireDelayTicks, float recoil) {
        this(new Item.Properties().func_200916_a(itemGroup).func_200918_c(durability), dmg, fireDelayTicks, recoil);
    }

    public double getDamage() {
        return this.dmg * (double)((Boolean)AoAConfig.COMMON.hardcoreMode.get() != false ? 1.25f : 1.0f);
    }

    public float getRecoil() {
        return this.recoil;
    }

    public int getFiringDelay() {
        return this.firingDelay;
    }

    private double getHolsterSpeed() {
        return this.holsterMod;
    }

    @Nullable
    public SoundEvent getFiringSound() {
        return null;
    }

    public float getRecoilForShot(ItemStack stack, LivingEntity shooter) {
        return this.getRecoil();
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repairMaterial) {
        return false;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        Item mainItem;
        ItemStack stack = player.func_184586_b(hand);
        if (hand != this.getGunHand(stack)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (player.func_184587_cr() && player.func_184585_cz()) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (hand == Hand.OFF_HAND && player.func_225608_bj_() && ((mainItem = player.func_184586_b(Hand.MAIN_HAND).func_77973_b()) instanceof BaseSniper || mainItem instanceof BaseStaff)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (player.func_184825_o(0.0f) < 1.0f) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        BaseBullet ammo = null;
        if (!world.field_72995_K) {
            ammo = this.findAndConsumeAmmo(player, stack, hand);
        }
        if (ammo != null) {
            world.func_217376_c(ammo);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            player.func_184811_cZ().func_185145_a((Item)this, this.getFiringDelay());
            ItemUtil.damageItem(stack, (LivingEntity)player, hand);
            if (this.getFiringSound() != null) {
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), this.getFiringSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            if (player instanceof ServerPlayerEntity) {
                int control = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.CONTROL.get()), (ItemStack)stack);
                float recoiling = this.getRecoilForShot(stack, (LivingEntity)player) * (1.0f - (float)control * 0.15f);
                AoAPackets.messagePlayer((ServerPlayerEntity)player, new GunRecoilPacket(hand == Hand.OFF_HAND ? recoiling * 2.5f : recoiling, this.getFiringDelay()));
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public Hand getGunHand(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.BRACE.get()), (ItemStack)stack) > 0 ? Hand.OFF_HAND : Hand.MAIN_HAND;
    }

    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target != null) {
            float shellMod = 1.0f;
            if (bullet.getHand() != null) {
                shellMod = (float)((double)shellMod + 0.1 * (double)EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.SHELL.get()), (ItemStack)shooter.func_184586_b(bullet.getHand())));
            }
            if (DamageUtil.dealGunDamage(target, shooter, bullet, (float)this.getDamage() * bulletDmgMultiplier * shellMod)) {
                this.doImpactEffect(target, shooter, bullet, bulletDmgMultiplier);
            } else if (!(target instanceof LivingEntity)) {
                target.func_70097_a(new IndirectEntityDamageSource("gun", (Entity)bullet, (Entity)shooter).func_76349_b(), (float)this.getDamage() * bulletDmgMultiplier * shellMod);
            }
        }
    }

    protected void doImpactEffect(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
    }

    public BaseBullet findAndConsumeAmmo(PlayerEntity player, ItemStack gunStack, Hand hand) {
        if (ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)AoAItems.LIMONITE_BULLET.get()), true, 1 + EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)gunStack))) {
            return new LimoniteBulletEntity((LivingEntity)player, (BaseGun)gunStack.func_77973_b(), hand, 120, 0);
        }
        return null;
    }

    public int func_77619_b() {
        return 8;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74774_a("HideFlags", (byte)2);
        return null;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(ATTACK_SPEED_MAINHAND, "AoAGunMainHand", -this.getHolsterSpeed(), AttributeModifier.Operation.MULTIPLY_TOTAL));
        } else if (slot == EquipmentSlotType.OFFHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(ATTACK_SPEED_OFFHAND, "AoAGunOffhand", -this.getHolsterSpeed(), AttributeModifier.Operation.MULTIPLY_TOTAL));
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)BraceEnchantment.BRACE_DEBUFF);
        }
        return multimap;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(1, LocaleUtil.getFormattedItemDescriptionText("items.description.damage.gun", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, NumberUtil.roundToNthDecimalPlace((float)this.getDamage() * (1.0f + 0.1f * (float)EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.SHELL.get()), (ItemStack)stack)), 2)));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.gun.firingSpeed", LocaleUtil.ItemDescriptionType.NEUTRAL, Double.toString((double)(2000 / this.firingDelay) / 100.0)));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.ammo.item", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, LocaleUtil.getItemName((IItemProvider)AoAItems.LIMONITE_BULLET.get())));
    }
}

