/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.gun;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.library.scheduling.AoAScheduler;
import net.tslat.aoa3.library.scheduling.async.EchoGullTask;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class EchoGull
extends BaseGun {
    public EchoGull(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(AoAItemGroups.GUNS, dmg, durability, firingDelayTicks, recoil);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_FAST_RIFLE_FIRE.get();
    }

    @Override
    protected void doImpactEffect(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        ArrayList<Tuple<LivingEntity, Integer>> entityList = new ArrayList<Tuple<LivingEntity, Integer>>();
        block0: for (LivingEntity entity : bullet.field_70170_p.func_175647_a(LivingEntity.class, bullet.func_174813_aQ().func_186662_g(30.0), EntityUtil.Predicates.HOSTILE_MOB)) {
            int distance = (int)entity.func_70032_d((Entity)bullet);
            if (entityList.isEmpty()) {
                entityList.add((Tuple<LivingEntity, Integer>)new Tuple((Object)entity, (Object)distance));
                continue;
            }
            for (int i = 0; i < entityList.size(); ++i) {
                int dist = (Integer)entityList.get(i).func_76340_b();
                if (dist != distance && dist <= distance) continue;
                entityList.add(i, (Tuple<LivingEntity, Integer>)new Tuple((Object)entity, (Object)distance));
                continue block0;
            }
        }
        AoAScheduler.scheduleSyncronisedTask(new EchoGullTask(bullet.field_70170_p, entityList), 1);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

