/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.gun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.entity.projectile.gun.LimoniteBulletEntity;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class FlamingFury
extends BaseGun {
    public FlamingFury(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(AoAItemGroups.GUNS, dmg, durability, firingDelayTicks, recoil);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_FAST_RIFLE_FIRE.get();
    }

    @Override
    public BaseBullet findAndConsumeAmmo(PlayerEntity player, ItemStack gunStack, Hand hand) {
        if (ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)AoAItems.LIMONITE_BULLET.get()), true, 1 + EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)gunStack))) {
            LimoniteBulletEntity bullet = new LimoniteBulletEntity((LivingEntity)player, (BaseGun)gunStack.func_77973_b(), hand, 120, 0);
            if (!player.field_70170_p.field_72995_K) {
                for (int i = 0; i < 6; ++i) {
                    ((ServerWorld)player.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197616_i, bullet.func_226277_ct_() + field_77697_d.nextGaussian() / 5.0, bullet.func_226278_cu_() + field_77697_d.nextGaussian() / 5.0, bullet.func_226281_cx_() + field_77697_d.nextGaussian() / 5.0, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
            return bullet;
        }
        return null;
    }

    @Override
    protected void doImpactEffect(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        AreaEffectCloudEntity cloud = new AreaEffectCloudEntity(bullet.field_70170_p, (target.func_226277_ct_() + bullet.func_226277_ct_()) / 2.0, (target.func_226278_cu_() + bullet.func_226278_cu_()) / 2.0, (target.func_226281_cx_() + bullet.func_226281_cx_()) / 2.0);
        cloud.func_184481_a(shooter);
        cloud.func_195059_a((IParticleData)ParticleTypes.field_197616_i);
        cloud.func_184483_a(1.0f);
        cloud.func_184485_d(0);
        cloud.func_184486_b(20);
        cloud.func_184487_c((5.0f - cloud.func_184490_j()) / (float)cloud.func_184489_o());
        cloud.func_184496_a(new EffectInstance(Effects.field_76433_i, 1, 0));
        bullet.field_70170_p.func_217376_c((Entity)cloud);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

