/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.gun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.entity.projectile.gun.BlueBulletEntity;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;

public class Frosticator
extends BaseGun {
    public Frosticator(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(AoAItemGroups.GUNS, dmg, durability, firingDelayTicks, recoil);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_GOLEM_GUN_FIRE.get();
    }

    @Override
    public BaseBullet findAndConsumeAmmo(PlayerEntity player, ItemStack gunStack, Hand hand) {
        if (ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)AoAItems.LIMONITE_BULLET.get()), true, 1 + EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)gunStack))) {
            return new BlueBulletEntity((LivingEntity)player, (BaseGun)gunStack.func_77973_b(), hand, 120, 0);
        }
        return null;
    }

    @Override
    protected void doImpactEffect(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target instanceof LivingEntity) {
            EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76421_d, 60).level(2));
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.damage.slow", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

