/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.maul;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireballEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.config.AoAConfig;
import net.tslat.aoa3.item.LongReachItem;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class BaseMaul
extends Item
implements LongReachItem {
    protected final AttributeModifier ATTACK_REACH_MODIFIER = new AttributeModifier(UUID.fromString("678cb085-1367-42c3-8437-d07ade6201d0"), "AoAMaulReach", (double)(this.getReach() - 3.5f), AttributeModifier.Operation.ADDITION);
    protected final float baseDamage;
    protected final double attackSpeed;
    protected final double knockback;

    public BaseMaul(float baseDmg, double attackSpeed, double knockback, int durability) {
        super(new Item.Properties().func_200918_c(durability).func_200916_a(AoAItemGroups.MAULS));
        this.baseDamage = baseDmg;
        this.attackSpeed = attackSpeed;
        this.knockback = knockback;
    }

    public float getAttackDamage() {
        return this.baseDamage * ((Boolean)AoAConfig.COMMON.hardcoreMode.get() != false ? 1.25f : 1.0f);
    }

    public double getAttackSpeed() {
        return this.attackSpeed;
    }

    public double getBaseKnockback() {
        return this.knockback;
    }

    @Override
    public float getReach() {
        return 4.0f;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BLOCK;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return false;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity holder) {
        if (!world.field_72995_K && (double)state.func_185887_b((IBlockReader)world, pos) != 0.0) {
            ItemUtil.damageItem(stack, holder, state.func_185904_a() == Material.field_151576_e ? 1 : 2, EquipmentSlotType.MAINHAND);
        }
        return true;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        return true;
    }

    @Override
    public boolean hitEntity(ItemStack stack, Entity target, LivingEntity attacker, float dmg) {
        if (dmg < 0.0f) {
            dmg = this.getAttackDamage() + 1.0f;
        }
        if (attacker instanceof PlayerEntity) {
            if (target instanceof FireballEntity) {
                target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)), dmg);
            } else {
                EffectInstance str = attacker.func_70660_b(Effects.field_76420_g);
                EffectInstance weak = attacker.func_70660_b(Effects.field_76437_t);
                float targetHealth = 0.0f;
                if (target instanceof LivingEntity) {
                    targetHealth = ((LivingEntity)target).func_110143_aJ();
                }
                if (str != null) {
                    dmg += (float)((str.func_76458_c() + 1) * 3);
                }
                if (weak != null) {
                    dmg -= (float)((weak.func_76458_c() + 1) * 4);
                }
                float cooldownMultiplier = ((PlayerEntity)attacker).func_184825_o(0.0f);
                float crushMod = 1.0f + 0.15f * (float)EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.CRUSH.get()), (ItemStack)stack);
                float finalDmg = dmg * cooldownMultiplier + 0.1f;
                if (target instanceof EnderDragonEntity ? ((EnderDragonEntity)target).func_213404_dT()[0].func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)), finalDmg) : target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)attacker)), finalDmg)) {
                    int hearts;
                    if (target instanceof LivingEntity) {
                        DamageUtil.doScaledKnockback((LivingEntity)target, (Entity)attacker, (float)this.knockback * crushMod * cooldownMultiplier, attacker.func_226277_ct_() - target.func_226277_ct_(), attacker.func_226281_cx_() - target.func_226281_cx_());
                    }
                    if (attacker.field_70170_p instanceof ServerWorld && target instanceof LivingEntity && (hearts = (int)((targetHealth - ((LivingEntity)target).func_110143_aJ()) / 2.0f)) > 0) {
                        ((ServerWorld)attacker.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, target.func_226277_ct_(), target.func_226278_cu_() + (double)(target.func_213302_cg() * 0.5f), target.func_226281_cx_(), hearts, 0.1, 0.0, 0.1, 0.2);
                    }
                    ItemUtil.damageItem(stack, attacker, 1, EquipmentSlotType.MAINHAND);
                    this.doMeleeEffect(stack, (PlayerEntity)attacker, target, finalDmg, cooldownMultiplier);
                }
            }
        } else if (target instanceof LivingEntity) {
            ((LivingEntity)target).func_70653_a((Entity)attacker, (float)this.knockback, attacker.func_226277_ct_() - target.func_226277_ct_(), attacker.func_226281_cx_() - target.func_226281_cx_());
        }
        return false;
    }

    protected void doMeleeEffect(ItemStack stack, PlayerEntity attacker, Entity target, float finalDmg, float attackCooldown) {
    }

    public int func_77619_b() {
        return 8;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)PlayerEntity.REACH_DISTANCE.func_111108_a(), (Object)this.ATTACK_REACH_MODIFIER);
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getAttackDamage(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.getAttackSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.maul.knockback", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, Double.toString((double)((int)(this.knockback * 700.0)) / 100.0)));
    }
}

