/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.shotgun;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.GunRecoilPacket;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.entity.projectile.gun.LimoniteBulletEntity;
import net.tslat.aoa3.entity.projectile.gun.MetalSlugEntity;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;

public class BaseShotgun
extends BaseGun {
    protected final int pelletCount;
    protected final float knockbackFactor;

    public BaseShotgun(double dmg, int pellets, int durability, int fireDelayTicks, float knockbackFactor, float recoil) {
        super(AoAItemGroups.SHOTGUNS, dmg, durability, fireDelayTicks, recoil);
        this.pelletCount = pellets;
        this.knockbackFactor = knockbackFactor;
    }

    public int getPelletCount() {
        return this.pelletCount;
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_SHOTGUN_FIRE.get();
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand != this.getGunHand(stack)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (player.func_184825_o(0.0f) < 1.0f) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        BaseBullet ammo = this.findAndConsumeAmmo(player, stack, hand);
        if (ammo != null) {
            if (!world.field_72995_K) {
                float form = 0.15f * (float)EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.FORM.get()), (ItemStack)stack);
                this.fireShotgun((LivingEntity)player, hand, 0.1f * (float)this.pelletCount * (1.0f - form), this.pelletCount);
            }
            if (this.getFiringSound() != null) {
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), this.getFiringSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            ItemUtil.damageItem(stack, (LivingEntity)player, hand);
            player.func_184811_cZ().func_185145_a((Item)this, this.getFiringDelay());
            if (player instanceof ServerPlayerEntity) {
                int control = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.CONTROL.get()), (ItemStack)stack);
                float recoiling = this.getRecoilForShot(stack, (LivingEntity)player) * (1.0f - (float)control * 0.15f);
                AoAPackets.messagePlayer((ServerPlayerEntity)player, new GunRecoilPacket(hand == Hand.OFF_HAND ? recoiling * 2.5f : recoiling, this.getFiringDelay()));
            }
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public void fireShotgun(LivingEntity shooter, Hand hand, float spreadFactor, int pellets) {
        for (int i = 0; i < pellets; ++i) {
            LimoniteBulletEntity pellet = new LimoniteBulletEntity(shooter, this, hand, 4, 1.0f, 0, (field_77697_d.nextFloat() - 0.5f) * spreadFactor, (field_77697_d.nextFloat() - 0.5f) * spreadFactor, (field_77697_d.nextFloat() - 0.5f) * spreadFactor);
            shooter.field_70170_p.func_217376_c((Entity)pellet);
        }
    }

    @Override
    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target != null) {
            float shellMod = 1.0f;
            if (bullet.getHand() != null) {
                shellMod = (float)((double)shellMod + 0.1 * (double)EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.SHELL.get()), (ItemStack)shooter.func_184586_b(bullet.getHand())));
            }
            if (DamageUtil.dealGunDamage(target, shooter, bullet, (float)this.getDamage() * bulletDmgMultiplier * shellMod)) {
                if (this.knockbackFactor > 0.0f && target instanceof LivingEntity) {
                    DamageUtil.doScaledKnockback((LivingEntity)target, (Entity)shooter, this.knockbackFactor, shooter.func_226277_ct_() - target.func_226277_ct_(), shooter.func_226281_cx_() - target.func_226281_cx_());
                }
                this.doImpactEffect(target, shooter, bullet, bulletDmgMultiplier);
            }
        }
    }

    @Override
    public BaseBullet findAndConsumeAmmo(PlayerEntity player, ItemStack gunStack, Hand hand) {
        if (ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)AoAItems.SPREADSHOT.get()), true, 1 + EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)gunStack))) {
            return new MetalSlugEntity((LivingEntity)player, (BaseGun)gunStack.func_77973_b(), hand, 4, 0);
        }
        return null;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(1, LocaleUtil.getFormattedItemDescriptionText("items.description.damage.shotgun", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, NumberUtil.roundToNthDecimalPlace((float)this.getDamage() * (1.0f + 0.1f * (float)EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.SHELL.get()), (ItemStack)stack)), 2), Integer.toString(this.pelletCount)));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.damage.knockback", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.gun.firingSpeed", LocaleUtil.ItemDescriptionType.NEUTRAL, Double.toString((double)(2000 / this.firingDelay) / 100.0)));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.ammo.item", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, LocaleUtil.getItemName((IItemProvider)AoAItems.SPREADSHOT.get())));
    }
}

