/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.sniper;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tslat.aoa3.client.gui.overlay.ScopeOverlayRenderer;
import net.tslat.aoa3.common.packet.AoAPackets;
import net.tslat.aoa3.common.packet.packets.GunRecoilPacket;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.entity.projectile.gun.SniperSlugEntity;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;

public abstract class BaseSniper
extends BaseGun {
    public BaseSniper(double dmg, int durability, int fireDelayTicks, float recoil) {
        super(AoAItemGroups.SNIPERS, dmg, durability, fireDelayTicks, recoil);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand != Hand.MAIN_HAND) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (player.func_184825_o(0.0f) < 1.0f) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        BaseBullet bullet = this.findAndConsumeAmmo(player, stack, hand);
        if (bullet != null) {
            if (!world.field_72995_K) {
                this.fireSniper((LivingEntity)player, hand, bullet);
            }
            if (this.getFiringSound() != null) {
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), this.getFiringSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            ItemUtil.damageItem(stack, (LivingEntity)player, hand);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            player.func_184811_cZ().func_185145_a((Item)this, this.getFiringDelay());
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public void fireSniper(LivingEntity shooter, Hand hand, BaseBullet bullet) {
        if (shooter.func_225608_bj_() && shooter.field_70122_E) {
            if (shooter instanceof ServerPlayerEntity) {
                int control = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.CONTROL.get()), (ItemStack)shooter.func_184586_b(hand));
                float recoiling = this.getRecoilForShot(shooter.func_184586_b(hand), shooter) * (1.0f - (float)control * 0.15f);
                AoAPackets.messagePlayer((ServerPlayerEntity)shooter, new GunRecoilPacket(recoiling, this.getFiringDelay()));
            }
        } else {
            bullet.func_184538_a((Entity)shooter, shooter.field_70125_A, shooter.field_70177_z, 0.0f, 20.0f, 50.0f);
            if (shooter instanceof ServerPlayerEntity) {
                AoAPackets.messagePlayer((ServerPlayerEntity)shooter, new GunRecoilPacket(this.getRecoil() * 2.0f, this.getFiringDelay()));
            }
        }
        shooter.field_70170_p.func_217376_c((Entity)bullet);
    }

    @Override
    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        super.doImpactDamage(target, shooter, bullet, bullet.getAge() <= 0 ? bulletDmgMultiplier * 0.5f : bulletDmgMultiplier);
    }

    @Override
    public BaseBullet findAndConsumeAmmo(PlayerEntity player, ItemStack gunStack, Hand hand) {
        if (ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)AoAItems.METAL_SLUG.get()), true, 1 + EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)gunStack))) {
            return new SniperSlugEntity((LivingEntity)player, (BaseGun)gunStack.func_77973_b(), 0);
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ScopeOverlayRenderer.Type getScopeType() {
        return ScopeOverlayRenderer.Type.BASIC;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(1, LocaleUtil.getFormattedItemDescriptionText("items.description.damage.gun", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, NumberUtil.roundToNthDecimalPlace((float)this.getDamage() * (1.0f + 0.1f * (float)EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.SHELL.get()), (ItemStack)stack)), 2)));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.sniper.use", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.gun.firingSpeed", LocaleUtil.ItemDescriptionType.NEUTRAL, Double.toString((double)(2000 / this.getFiringDelay()) / 100.0)));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.ammo.item", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, LocaleUtil.getItemName((IItemProvider)AoAItems.METAL_SLUG.get())));
    }
}

