/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.sniper;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.client.gui.overlay.ScopeOverlayRenderer;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;

public class Crystaneer
extends BaseSniper {
    private static final ArrayList<ItemStack> gemDrops = new ArrayList(5);
    private static boolean populated = false;

    public Crystaneer(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_SNIPER_FIRE.get();
    }

    @Override
    public ScopeOverlayRenderer.Type getScopeType() {
        return ScopeOverlayRenderer.Type.CRYSTAL;
    }

    @Override
    protected void doImpactEffect(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        if (target instanceof LivingEntity && ((LivingEntity)target).func_110143_aJ() <= 0.0f && RandomUtil.oneInNChance(5)) {
            if (!populated) {
                Crystaneer.populateGemDrops();
            }
            target.func_70099_a(RandomUtil.getRandomSelection(gemDrops), 0.0f);
        }
    }

    private static void populateGemDrops() {
        gemDrops.add(new ItemStack((IItemProvider)Items.field_151045_i));
        gemDrops.add(new ItemStack((IItemProvider)Items.field_151166_bC));
        gemDrops.add(new ItemStack((IItemProvider)AoAItems.SAPPHIRE.get()));
        gemDrops.add(new ItemStack((IItemProvider)AoAItems.JADE.get()));
        gemDrops.add(new ItemStack((IItemProvider)AoAItems.AMETHYST.get()));
        populated = true;
    }

    public static void addGemDrop(ItemStack stack) {
        if (!populated) {
            Crystaneer.populateGemDrops();
        }
        gemDrops.add(stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.UNIQUE, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

