/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.sniper;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tslat.aoa3.client.gui.overlay.ScopeOverlayRenderer;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.item.weapon.sniper.BaseSniper;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class HeadHunter
extends BaseSniper {
    public HeadHunter(double dmg, int durability, int firingDelayTicks, float recoil) {
        super(dmg, durability, firingDelayTicks, recoil);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return (SoundEvent)AoASounds.ITEM_SNIPER_FIRE.get();
    }

    @Override
    public ScopeOverlayRenderer.Type getScopeType() {
        return ScopeOverlayRenderer.Type.DOTTED;
    }

    @Override
    protected void doImpactEffect(Entity target, LivingEntity shooter, BaseBullet bullet, float bulletDmgMultiplier) {
        Vec3d preciseImpactSpot;
        if (target instanceof LivingEntity && target.field_70170_p instanceof ServerWorld && (preciseImpactSpot = EntityUtil.preciseEntityInterceptCalculation(target, (Entity)bullet, 20)) != null) {
            double headMinRange = target.func_174813_aQ().field_72338_b + (double)target.func_70047_e() - (double)(target.func_213302_cg() * 0.105f);
            double headMaxRange = headMinRange + (double)(target.func_213302_cg() * 0.225f);
            if (preciseImpactSpot.field_72448_b > headMinRange && preciseImpactSpot.field_72448_b < headMaxRange) {
                for (int i = 0; i < 5; ++i) {
                    ((ServerWorld)target.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197615_h, preciseImpactSpot.field_72450_a + field_77697_d.nextDouble() - 0.5, preciseImpactSpot.field_72448_b + field_77697_d.nextDouble() - 0.5, preciseImpactSpot.field_72449_c + field_77697_d.nextDouble() - 0.5, 3, 0.0, 0.0, 0.0, 0.0);
                }
                if (shooter.func_184586_b(Hand.MAIN_HAND).func_77973_b() != this && shooter.func_184586_b(Hand.OFF_HAND).func_77973_b() != this) {
                    return;
                }
                if (shooter instanceof PlayerEntity) {
                    if (shooter instanceof ServerPlayerEntity) {
                        PlayerUtil.playSoundForPlayer((ServerPlayerEntity)shooter, (SoundEvent)AoASounds.SKILL_LOOT.get(), SoundCategory.PLAYERS, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), 0.3f, 1.0f);
                    }
                    ((PlayerEntity)shooter).func_184811_cZ().func_185145_a((Item)this, (int)((float)this.getFiringDelay() / 2.0f));
                }
            }
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

