/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.item.EnergyProjectileWeapon;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.blaster.BaseBlaster;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public abstract class BaseStaff<T>
extends Item
implements EnergyProjectileWeapon {
    protected final HashMap<RuneItem, Integer> runes = new HashMap(2);

    public BaseStaff(int durability) {
        super(new Item.Properties().func_200916_a(AoAItemGroups.STAVES).func_200918_c(durability));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        Item mainItem;
        ItemStack stack = player.func_184586_b(hand);
        if (hand == Hand.OFF_HAND && ((mainItem = player.func_184586_b(Hand.MAIN_HAND).func_77973_b()) instanceof BaseGun || mainItem instanceof BaseBlaster)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        if (player instanceof ServerPlayerEntity) {
            T preconditionResult = this.checkPreconditions((LivingEntity)player, stack);
            if (preconditionResult == null) {
                return ActionResult.func_226251_d_((Object)stack);
            }
            if (!this.findAndConsumeRunes(this.getRunes(), (ServerPlayerEntity)player, true, stack)) {
                return ActionResult.func_226251_d_((Object)stack);
            }
            if (this.getCastingSound() != null) {
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), this.getCastingSound(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            player.func_184811_cZ().func_185145_a((Item)this, 12);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            ItemUtil.damageItem(stack, (LivingEntity)player, hand);
            this.cast(world, stack, (LivingEntity)player, preconditionResult);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public boolean findAndConsumeRunes(HashMap<RuneItem, Integer> runes, ServerPlayerEntity player, boolean allowBuffs, ItemStack staff) {
        return ItemUtil.findAndConsumeRunes(runes, player, allowBuffs, staff);
    }

    @Nullable
    public T checkPreconditions(LivingEntity caster, ItemStack staff) {
        return (T)new Object();
    }

    public HashMap<RuneItem, Integer> getRunes() {
        if (this.runes.isEmpty()) {
            this.populateRunes(this.runes);
        }
        return this.runes;
    }

    @Nullable
    public SoundEvent getCastingSound() {
        return null;
    }

    protected abstract void populateRunes(HashMap<RuneItem, Integer> var1);

    public abstract void cast(World var1, ItemStack var2, LivingEntity var3, T var4);

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3d hitPos, LivingEntity shooter) {
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        return true;
    }

    @Override
    public Hand getWeaponHand(LivingEntity holder) {
        return holder.func_184614_ca().func_77973_b() == this || holder.func_184592_cb().func_77973_b() != this ? Hand.MAIN_HAND : Hand.OFF_HAND;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public float getDmg() {
        return 0.0f;
    }

    public int func_77619_b() {
        return 8;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (this.getDmg() > 0.0f) {
            tooltip.add(1, LocaleUtil.getFormattedItemDescriptionText("items.description.damage.magic", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, Float.toString(this.getDmg())));
        }
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.staff.runesRequired", LocaleUtil.ItemDescriptionType.ITEM_AMMO_COST, new String[0]));
        for (Map.Entry<RuneItem, Integer> runeEntry : this.getRunes().entrySet()) {
            tooltip.add((ITextComponent)LocaleUtil.getLocaleMessage("items.description.staff.runesRequired.specific", TextFormatting.WHITE, Integer.toString(runeEntry.getValue()), LocaleUtil.getItemName((IItemProvider)runeEntry.getKey())));
        }
    }
}

