/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectile.staff.CelestialFallEntity;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class CelestialStaff
extends BaseStaff<BlockPos> {
    public CelestialStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_CELESTIAL_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.COMPASS_RUNE.get(), 1);
        runes.put((RuneItem)AoAItems.LUNAR_RUNE.get(), 2);
        runes.put((RuneItem)AoAItems.ENERGY_RUNE.get(), 2);
    }

    @Override
    public BlockPos checkPreconditions(LivingEntity caster, ItemStack staff) {
        BlockPos trace = null;
        if (caster instanceof PlayerEntity) {
            trace = PlayerUtil.getBlockAimingAt((PlayerEntity)caster, 70.0);
        }
        return trace;
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, BlockPos args) {
        BlockPos pos = args;
        world.func_217376_c((Entity)new CelestialFallEntity(caster, this, pos.func_177958_n(), pos.func_177956_o() + 25, pos.func_177952_p(), 3.0f));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3d hitPos, LivingEntity shooter) {
        WorldUtil.createExplosion((Entity)shooter, shot.field_70170_p, (Entity)shot, 2.5f);
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        WorldUtil.createExplosion((Entity)shooter, shot.field_70170_p, (Entity)shot, 2.5f);
        return DamageUtil.dealMagicDamage((Entity)shot, shooter, target, this.getDmg(), false);
    }

    @Override
    public float getDmg() {
        return 11.0f;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

