/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.WorldUtil;

public class ConcussionStaff
extends BaseStaff<List<LivingEntity>> {
    public ConcussionStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_CONCUSSION_STAFF_CAST.get();
    }

    @Override
    public List<LivingEntity> checkPreconditions(LivingEntity caster, ItemStack staff) {
        List list = caster.field_70170_p.func_175647_a(LivingEntity.class, caster.func_174813_aQ().func_186662_g(8.0), EntityUtil.Predicates.HOSTILE_MOB);
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.POWER_RUNE.get(), 4);
        runes.put((RuneItem)AoAItems.STORM_RUNE.get(), 4);
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, List<LivingEntity> args) {
        for (LivingEntity e : args) {
            EntityUtil.pushEntityAway((Entity)caster, (Entity)e, 3.0f);
            WorldUtil.createExplosion((Entity)caster, e.field_70170_p, e.func_226277_ct_(), e.func_226278_cu_() + (double)e.func_213302_cg() + 0.5, e.func_226281_cx_(), 2.3f);
            EntityUtil.applyPotions((Entity)e, new PotionUtil.EffectBuilder(Effects.field_76421_d, 25).level(10));
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

