/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoABlocks;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.scheduling.async.CoralStaffTask;
import net.tslat.aoa3.util.LocaleUtil;

public class CoralStaff
extends BaseStaff<ArrayList<BlockPos>> {
    public CoralStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_CORAL_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.WATER_RUNE.get(), 2);
        runes.put((RuneItem)AoAItems.KINETIC_RUNE.get(), 8);
    }

    @Override
    @Nullable
    public ArrayList<BlockPos> checkPreconditions(LivingEntity caster, ItemStack staff) {
        int y;
        ArrayList<BlockPos> coralPositions = new ArrayList<BlockPos>();
        BlockPos pos = caster.func_180425_c();
        BlockPos.Mutable checkPos = new BlockPos.Mutable();
        for (int x = -2; x <= 1; ++x) {
            for (int z = -2; z <= 1; ++z) {
                checkPos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() - 2, pos.func_177952_p() + z);
                if (this.safeBlockPos(caster, (BlockPos)checkPos)) {
                    coralPositions.add(checkPos.func_185334_h());
                }
                if (!this.safeBlockPos(caster, (BlockPos)checkPos.func_189534_c(Direction.UP, 4))) continue;
                coralPositions.add(checkPos.func_185334_h());
            }
            for (y = -2; y <= 2; ++y) {
                checkPos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() - 2);
                if (this.safeBlockPos(caster, (BlockPos)checkPos)) {
                    coralPositions.add(checkPos.func_185334_h());
                }
                if (!this.safeBlockPos(caster, (BlockPos)checkPos.func_189534_c(Direction.SOUTH, 4))) continue;
                coralPositions.add(checkPos.func_185334_h());
            }
        }
        for (int z = -2; z <= 2; ++z) {
            for (y = -2; y <= 2; ++y) {
                checkPos.func_181079_c(pos.func_177958_n() - 2, pos.func_177956_o() + y, pos.func_177952_p() + z);
                if (this.safeBlockPos(caster, (BlockPos)checkPos)) {
                    coralPositions.add(checkPos.func_185334_h());
                }
                if (!this.safeBlockPos(caster, (BlockPos)checkPos.func_189534_c(Direction.EAST, 4))) continue;
                coralPositions.add(checkPos.func_185334_h());
            }
        }
        return coralPositions.isEmpty() ? null : coralPositions;
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, ArrayList<BlockPos> args) {
        if (!world.field_72995_K && caster instanceof PlayerEntity) {
            for (BlockPos pos : args) {
                world.func_180501_a(pos, ((Block)AoABlocks.PINK_CORAL.get()).func_176223_P(), 2);
            }
            world.func_184148_a(null, caster.func_226277_ct_(), caster.func_226278_cu_(), caster.func_226281_cx_(), (SoundEvent)AoASounds.ITEM_REEF_STAFF_CAST.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            new CoralStaffTask(world, args).schedule(30, TimeUnit.SECONDS);
        }
    }

    private boolean safeBlockPos(LivingEntity caster, BlockPos pos) {
        return caster.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a && (!(caster instanceof PlayerEntity) || caster.field_70170_p.canMineBlockBody((PlayerEntity)caster, pos));
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

