/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class CrystalStaff
extends BaseStaff<List<PlayerEntity>> {
    public CrystalStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_CRYSTEVIA_STAFF_CAST.get();
    }

    @Override
    public List<PlayerEntity> checkPreconditions(LivingEntity caster, ItemStack staff) {
        List playerList = caster.field_70170_p.func_175647_a(PlayerEntity.class, caster.func_174813_aQ().func_186662_g(20.0), PlayerUtil::shouldPlayerBeAffected);
        if (playerList.isEmpty()) {
            return null;
        }
        for (PlayerEntity pl : playerList) {
            if (pl.func_110143_aJ() == pl.func_110138_aP()) continue;
            return playerList;
        }
        return null;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.DISTORTION_RUNE.get(), 2);
        runes.put((RuneItem)AoAItems.LIFE_RUNE.get(), 5);
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, List<PlayerEntity> args) {
        float currentTotalHealth = 0.0f;
        float currentMaxHealth = 0.0f;
        for (PlayerEntity pl : args) {
            currentMaxHealth += pl.func_110138_aP();
            currentTotalHealth += pl.func_110143_aJ();
        }
        float healthPerPlayer = currentMaxHealth * (currentTotalHealth / currentMaxHealth * 1.25f) / (float)args.size();
        for (PlayerEntity pl : args) {
            pl.func_70606_j(healthPerPlayer);
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 2, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

