/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;

public class EvermightStaff
extends BaseStaff<Float> {
    public EvermightStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_EMBER_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.DISTORTION_RUNE.get(), 2);
        runes.put((RuneItem)AoAItems.POWER_RUNE.get(), 4);
    }

    @Override
    public Float checkPreconditions(LivingEntity caster, ItemStack staff) {
        float healthPercent = EntityUtil.getCurrentHealthPercent(caster);
        return healthPercent < 1.0f && healthPercent > 0.0f ? Float.valueOf(healthPercent) : null;
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, Float args) {
        EntityUtil.applyPotions((Entity)caster, new PotionUtil.EffectBuilder(Effects.field_76420_g, (int)(1200.0f * (1.0f - args.floatValue()))).level((double)args.floatValue() < 0.1 ? 3 : ((double)args.floatValue() < 0.5 ? 2 : 1)));
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

