/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectile.staff.FireflyShotEntity;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;

public class FireflyStaff
extends BaseStaff<Object> {
    public FireflyStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_FIREFLY_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.WIND_RUNE.get(), 2);
        runes.put((RuneItem)AoAItems.STRIKE_RUNE.get(), 2);
        runes.put((RuneItem)AoAItems.FIRE_RUNE.get(), 1);
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, Object args) {
        world.func_217376_c((Entity)new FireflyShotEntity(caster, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (DamageUtil.dealMagicDamage((Entity)shot, shooter, target, this.getDmg(), false)) {
            target.func_70015_d(5);
            UUID targetUUID = target.func_110124_au();
            if (targetUUID.equals(((FireflyShotEntity)shot).lastTargetUUID)) {
                return true;
            }
            for (int i = 0; i < RandomUtil.randomNumberBetween(1, 7); ++i) {
                shot.field_70170_p.func_217376_c((Entity)new FireflyShotEntity(shooter, this, (FireflyShotEntity)shot, targetUUID, field_77697_d.nextGaussian() * 0.35, (double)1.4f, field_77697_d.nextGaussian() * 0.35));
            }
            return true;
        }
        return false;
    }

    @Override
    public float getDmg() {
        return 11.0f;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

