/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.MushroomBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;

public class FungalStaff
extends BaseStaff<HashMap<BlockPos, Boolean>> {
    public FungalStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_FUNGAL_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.DISTORTION_RUNE.get(), 5);
        runes.put((RuneItem)AoAItems.LIFE_RUNE.get(), 2);
    }

    @Override
    @Nullable
    public HashMap<BlockPos, Boolean> checkPreconditions(LivingEntity caster, ItemStack staff) {
        BlockPos.Mutable checkPos = new BlockPos.Mutable();
        HashMap<BlockPos, Boolean> workablePositions = new HashMap<BlockPos, Boolean>();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    Block block = caster.field_70170_p.func_180495_p((BlockPos)checkPos.func_189532_c(caster.func_226277_ct_() + (double)x, caster.func_226278_cu_() + (double)y, caster.func_226281_cx_() + (double)z)).func_177230_c();
                    if (block == Blocks.field_196658_i) {
                        workablePositions.put(checkPos.func_185334_h(), true);
                        continue;
                    }
                    if (!(block instanceof MushroomBlock)) continue;
                    workablePositions.put(checkPos.func_185334_h(), false);
                }
            }
        }
        return workablePositions.isEmpty() ? null : workablePositions;
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, HashMap<BlockPos, Boolean> args) {
        if (world instanceof ServerWorld) {
            for (Map.Entry<BlockPos, Boolean> entry : args.entrySet()) {
                if (entry.getValue().booleanValue()) {
                    world.func_175656_a(entry.getKey(), Blocks.field_150391_bh.func_176223_P());
                } else {
                    BlockPos pos = entry.getKey();
                    BlockState state = world.func_180495_p(pos);
                    MushroomBlock mushroom = (MushroomBlock)state.func_177230_c();
                    if (mushroom.func_176473_a((IBlockReader)world, pos, state, false) && mushroom.func_180670_a(world, field_77697_d, pos, state)) {
                        mushroom.func_225535_a_((ServerWorld)world, field_77697_d, pos, state);
                    }
                }
                world.func_217379_c(2005, entry.getKey(), 0);
            }
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 2, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

