/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectile.staff.LyonicShotEntity;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.RandomUtil;

public class LyonicStaff
extends BaseStaff<List<LivingEntity>> {
    public LyonicStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.ENERGY_RUNE.get(), 1);
        runes.put((RuneItem)AoAItems.WIND_RUNE.get(), 1);
        runes.put((RuneItem)AoAItems.WITHER_RUNE.get(), 2);
        runes.put((RuneItem)AoAItems.STRIKE_RUNE.get(), 1);
    }

    @Override
    @Nullable
    public List<LivingEntity> checkPreconditions(LivingEntity caster, ItemStack staff) {
        List targets = caster.field_70170_p.func_175647_a(LivingEntity.class, caster.func_174813_aQ().func_72314_b(10.0, 1.0, 10.0), entity -> entity instanceof IMob && entity.func_70089_S());
        return targets.isEmpty() ? null : targets;
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, List<LivingEntity> args) {
        for (float x = -1.0f; x <= 1.0f; x += 0.125f) {
            for (float z = -1.0f; z <= 1.0f; z += 0.125f) {
                world.func_217376_c((Entity)new LyonicShotEntity(caster, this, 1, x, 0.0f, z));
            }
        }
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (EntityUtil.isHostileMob(target) && target.field_70170_p instanceof ServerWorld) {
            EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_82731_v, 100).level(2));
            if (RandomUtil.oneInNChance(150)) {
                ((ServerWorld)target.field_70170_p).func_217468_a(new LightningBoltEntity(target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), false));
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.damage.wither", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 2, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

