/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectile.staff.LyonicShotEntity;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.RandomUtil;

public class MechaStaff
extends BaseStaff<Object> {
    private static final AttributeModifier DEBUFF = new AttributeModifier(UUID.fromString("3a1413c7-055b-405c-8d89-d3270c94f133"), "AoAMechaStaffDebuff", -0.5, AttributeModifier.Operation.MULTIPLY_BASE);

    public MechaStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.WIND_RUNE.get(), 2);
        runes.put((RuneItem)AoAItems.DISTORTION_RUNE.get(), 1);
        runes.put((RuneItem)AoAItems.POWER_RUNE.get(), 1);
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, Object args) {
        world.func_217376_c((Entity)new LyonicShotEntity(caster, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (target instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)target;
            IAttributeInstance armour = entity.func_110148_a(SharedMonsterAttributes.field_188791_g);
            if (armour != null && armour.func_111126_e() > 0.0 && !armour.func_180374_a(DEBUFF)) {
                EntityUtil.applyAttributeModifierSafely(entity, SharedMonsterAttributes.field_188791_g, DEBUFF);
                if (!entity.field_70170_p.field_72995_K) {
                    AxisAlignedBB bounds = entity.func_174813_aQ();
                    for (int i = 0; i < 8; ++i) {
                        ((ServerWorld)entity.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197604_O, bounds.field_72340_a + (double)RandomUtil.randomValueUpTo(entity.func_213311_cf()), bounds.field_72337_e + 0.1, bounds.field_72339_c + (double)RandomUtil.randomValueUpTo(entity.func_213311_cf()), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

