/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectile.staff.MoonlightFallEntity;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class MoonlightStaff
extends BaseStaff<BlockPos> {
    public MoonlightStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_MOONLIGHT_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.COMPASS_RUNE.get(), 1);
        runes.put((RuneItem)AoAItems.LUNAR_RUNE.get(), 2);
        runes.put((RuneItem)AoAItems.KINETIC_RUNE.get(), 2);
    }

    @Override
    public BlockPos checkPreconditions(LivingEntity caster, ItemStack staff) {
        BlockPos trace = null;
        if (caster instanceof PlayerEntity) {
            trace = PlayerUtil.getBlockAimingAt((PlayerEntity)caster, 70.0);
        }
        return trace;
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, BlockPos args) {
        world.func_217376_c((Entity)new MoonlightFallEntity(caster, this, args.func_177958_n(), args.func_177956_o() + 30, args.func_177952_p(), 3.0f));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3d hitPos, LivingEntity caster) {
        this.createCloud(shot, caster);
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity caster) {
        if (!target.func_190530_aW()) {
            this.createCloud(shot, caster);
            return true;
        }
        return false;
    }

    private void createCloud(BaseEnergyShot shot, LivingEntity caster) {
        AreaEffectCloudEntity cloud = new AreaEffectCloudEntity(shot.field_70170_p, shot.func_226277_ct_(), shot.func_226278_cu_(), shot.func_226281_cx_());
        cloud.func_184481_a(caster);
        cloud.func_184496_a(new EffectInstance(Effects.field_76421_d, 140, 1, false, true));
        cloud.func_184483_a(0.1f);
        cloud.func_184487_c(1.0f);
        cloud.func_184486_b(10);
        cloud.func_184485_d(0);
        shot.field_70170_p.func_217376_c((Entity)cloud);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

