/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.IGrowable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.WorldUtil;

public class NatureStaff
extends BaseStaff<ArrayList<BlockPos>> {
    public NatureStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_NATURE_STAFF_CAST.get();
    }

    @Override
    public ArrayList<BlockPos> checkPreconditions(LivingEntity caster, ItemStack staff) {
        ArrayList<BlockPos> blocks = WorldUtil.getBlocksWithinAABB(caster.field_70170_p, caster.func_174813_aQ().func_186662_g(10.0), (state, pos) -> state.func_177230_c() instanceof IGrowable && ((IGrowable)state.func_177230_c()).func_176473_a((IBlockReader)caster.field_70170_p, pos.func_185334_h(), state, false));
        return blocks.isEmpty() ? null : blocks;
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.LIFE_RUNE.get(), 4);
        runes.put((RuneItem)AoAItems.ENERGY_RUNE.get(), 2);
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, ArrayList<BlockPos> args) {
        for (BlockPos pos : args) {
            BoneMealItem.func_195966_a((ItemStack)new ItemStack((IItemProvider)Items.field_196106_bc), (World)caster.field_70170_p, (BlockPos)pos);
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

