/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potions;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectile.staff.NoxiousShotEntity;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.NumberUtil;
import net.tslat.aoa3.util.PotionUtil;

public class NoxiousStaff
extends BaseStaff<Object> {
    public NoxiousStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_NOXIOUS_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.WIND_RUNE.get(), 2);
        runes.put((RuneItem)AoAItems.POISON_RUNE.get(), 2);
        runes.put((RuneItem)AoAItems.STORM_RUNE.get(), 2);
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, Object args) {
        world.func_217376_c((Entity)new NoxiousShotEntity(caster, this, 60, 0.0f, 0.0f, 0.0f));
        world.func_217376_c((Entity)new NoxiousShotEntity(caster, this, 60, 0.075f, 0.075f, 0.0f));
        world.func_217376_c((Entity)new NoxiousShotEntity(caster, this, 60, -0.075f, 0.0f, 0.075f));
        world.func_217376_c((Entity)new NoxiousShotEntity(caster, this, 60, 0.0f, -0.075f, -0.075f));
        world.func_217376_c((Entity)new NoxiousShotEntity(caster, this, 60, -0.075f, 0.075f, -0.075f));
        world.func_217376_c((Entity)new NoxiousShotEntity(caster, this, 60, -0.075f, -0.075f, 0.075f));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (DamageUtil.dealMagicDamage((Entity)shot, shooter, target, this.getDmg(), false)) {
            EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76436_u, 100).level(3));
            return true;
        }
        return false;
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3d pos, LivingEntity shooter) {
        AreaEffectCloudEntity cloud = new AreaEffectCloudEntity(shot.field_70170_p, shot.func_226277_ct_(), shot.func_226278_cu_(), shot.func_226281_cx_());
        cloud.func_184483_a(3.0f);
        cloud.func_184484_a(Potions.field_185219_B);
        cloud.func_184496_a(new EffectInstance(Effects.field_76436_u, 100, 2, true, true));
        cloud.func_184486_b(3);
        cloud.func_184482_a(NumberUtil.RGB(51, 102, 0));
        cloud.func_184481_a(shooter);
        shot.field_70170_p.func_217376_c((Entity)cloud);
    }

    @Override
    public float getDmg() {
        return 3.5f;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

