/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;

public class ShowStaff
extends BaseStaff<List<LivingEntity>> {
    public ShowStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_SHOW_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.COMPASS_RUNE.get(), 3);
        runes.put((RuneItem)AoAItems.POWER_RUNE.get(), 3);
    }

    @Override
    public List<LivingEntity> checkPreconditions(LivingEntity caster, ItemStack staff) {
        List list = caster.field_70170_p.func_175647_a(LivingEntity.class, caster.func_174813_aQ().func_186662_g(30.0), EntityUtil.Predicates.HOSTILE_MOB);
        if (!list.isEmpty()) {
            return list;
        }
        return null;
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, List<LivingEntity> args) {
        for (LivingEntity entity : args) {
            entity.func_70015_d(5);
            EntityUtil.applyPotions((Entity)entity, new PotionUtil.EffectBuilder(Effects.field_188423_x, 100));
            world.func_217376_c((Entity)new FireworkRocketEntity(world, entity.func_226277_ct_(), entity.func_174813_aQ().field_72337_e, entity.func_226281_cx_(), this.makeFireworksStack()));
        }
    }

    private ItemStack makeFireworksStack() {
        ItemStack fireworks = new ItemStack((IItemProvider)Items.field_196152_dE, 1);
        CompoundNBT explosionTag = new CompoundNBT();
        CompoundNBT fireworksTag = new CompoundNBT();
        CompoundNBT finalTag = new CompoundNBT();
        CompoundNBT wrapperTag = new CompoundNBT();
        ListNBT finalTagList = new ListNBT();
        explosionTag.func_74757_a("Trail", true);
        explosionTag.func_74783_a("Colors", new int[]{0});
        explosionTag.func_74774_a("Type", (byte)4);
        fireworksTag.func_218657_a("Explosion", (INBT)explosionTag);
        finalTagList.add((Object)fireworksTag);
        finalTag.func_218657_a("Explosions", (INBT)finalTagList);
        finalTag.func_74774_a("Flight", (byte)3);
        wrapperTag.func_218657_a("Fireworks", (INBT)finalTag);
        fireworks.func_77982_d(wrapperTag);
        return fireworks;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

