/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoADimensions;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectile.staff.ShyreShotEntity;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.AdvancementUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class ShyreStaff
extends BaseStaff<Object> {
    public ShyreStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_SHYRE_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.ENERGY_RUNE.get(), 3);
        runes.put((RuneItem)AoAItems.DISTORTION_RUNE.get(), 3);
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, Object args) {
        world.func_217376_c((Entity)new ShyreShotEntity(caster, this, 120));
    }

    @Override
    public void doBlockImpact(BaseEnergyShot shot, Vec3d hitPos, LivingEntity shooter) {
        World world = shooter.field_70170_p;
        BlockPos.Mutable testPos = new BlockPos.Mutable(hitPos.func_82615_a(), hitPos.func_82617_b(), hitPos.func_82616_c());
        BlockState state = world.func_180495_p((BlockPos)testPos);
        Vec3d shotMotion = shot.func_213322_ci();
        Vec3d testVec = hitPos;
        for (int tests = 0; tests <= 10 && !(state = world.func_180495_p((BlockPos)testPos)).func_177230_c().isAir(state, (IBlockReader)world, (BlockPos)testPos); ++tests) {
            testVec = testVec.func_178786_a(shotMotion.func_82615_a() * (double)0.15f, shotMotion.func_82617_b() * (double)0.15f, shotMotion.func_82616_c() * (double)0.15f);
            testPos.func_189532_c(testVec.func_82615_a() + (double)shooter.func_213311_cf(), testVec.func_82617_b(), testVec.func_82616_c() + (double)shooter.func_213311_cf());
        }
        if (state.func_177230_c().isAir(state, (IBlockReader)world, (BlockPos)testPos)) {
            shooter.func_70634_a(testVec.func_82615_a(), testVec.func_82617_b(), testVec.func_82616_c());
            if (shooter instanceof ServerPlayerEntity && shooter.field_70170_p.func_201675_m().func_186058_p() == AoADimensions.LUNALUS.type()) {
                AdvancementUtil.completeAdvancement((ServerPlayerEntity)shooter, new ResourceLocation("aoa3", "lunalus/200_iq"), "lunalus_shyre_staff_travel");
            }
        }
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        shooter.func_70634_a((target.func_226277_ct_() + shot.func_226277_ct_()) / 2.0, (target.func_226278_cu_() + shot.func_226278_cu_()) / 2.0, (target.func_226281_cx_() + shot.func_226281_cx_()) / 2.0);
        return true;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

