/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.LocaleUtil;

public class SkyStaff
extends BaseStaff<Boolean> {
    public SkyStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_SKY_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.WIND_RUNE.get(), 2);
        runes.put((RuneItem)AoAItems.KINETIC_RUNE.get(), 2);
        runes.put((RuneItem)AoAItems.ENERGY_RUNE.get(), 1);
    }

    @Override
    public Boolean checkPreconditions(LivingEntity caster, ItemStack staff) {
        return caster.field_70122_E ? Boolean.valueOf(true) : null;
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, Boolean args) {
        caster.func_70031_b(true);
        double xMotion = -MathHelper.func_76126_a((float)(caster.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(caster.field_70125_A / 180.0f * (float)Math.PI)) * 2.0f;
        double zMotion = MathHelper.func_76134_b((float)(caster.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(caster.field_70125_A / 180.0f * (float)Math.PI)) * 2.0f;
        double yMotion = caster.func_213322_ci().func_82617_b();
        yMotion = Math.abs(xMotion) < 0.4 && Math.abs(zMotion) < 0.4 ? (yMotion += 2.0) : (yMotion += 0.75);
        caster.func_213317_d(new Vec3d(xMotion, yMotion, zMotion));
        caster.field_70133_I = true;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 2, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

