/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectile.staff.TangleFallEntity;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;
import net.tslat.aoa3.util.RandomUtil;
import net.tslat.aoa3.util.player.PlayerUtil;

public class TangleStaff
extends BaseStaff<BlockPos> {
    public TangleStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_TANGLE_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.WIND_RUNE.get(), 2);
        runes.put((RuneItem)AoAItems.POISON_RUNE.get(), 2);
        runes.put((RuneItem)AoAItems.STORM_RUNE.get(), 1);
    }

    @Override
    public BlockPos checkPreconditions(LivingEntity caster, ItemStack staff) {
        BlockPos trace = null;
        if (caster instanceof PlayerEntity) {
            trace = PlayerUtil.getBlockAimingAt((PlayerEntity)caster, 70.0);
        }
        return trace;
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, BlockPos args) {
        BlockPos pos = args;
        for (int i = 0; i < 8; ++i) {
            world.func_217376_c((Entity)new TangleFallEntity(caster, this, (float)(pos.func_177958_n() - 4) + RandomUtil.randomValueUpTo(8.0f), pos.func_177956_o() + 30, (float)(pos.func_177952_p() - 4) + RandomUtil.randomValueUpTo(8.0f), 3.0f));
        }
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (DamageUtil.dealMagicDamage((Entity)shot, shooter, target, this.getDmg(), false)) {
            EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76421_d, 60).level(50));
            return true;
        }
        return false;
    }

    @Override
    public float getDmg() {
        return 9.0f;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

