/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.staff;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.staff.BaseEnergyShot;
import net.tslat.aoa3.entity.projectile.staff.UltimatumShotEntity;
import net.tslat.aoa3.item.misc.RuneItem;
import net.tslat.aoa3.item.weapon.staff.BaseStaff;
import net.tslat.aoa3.library.scheduling.AoAScheduler;
import net.tslat.aoa3.library.scheduling.sync.UltimatumStaffTask;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class UltimatumStaff
extends BaseStaff<Object> {
    public UltimatumStaff(int durability) {
        super(durability);
    }

    @Override
    @Nullable
    public SoundEvent getCastingSound() {
        return (SoundEvent)AoASounds.ITEM_ULTIMATUM_STAFF_CAST.get();
    }

    @Override
    protected void populateRunes(HashMap<RuneItem, Integer> runes) {
        runes.put((RuneItem)AoAItems.LIFE_RUNE.get(), 5);
        runes.put((RuneItem)AoAItems.POWER_RUNE.get(), 3);
        runes.put((RuneItem)AoAItems.DISTORTION_RUNE.get(), 8);
    }

    @Override
    public void cast(World world, ItemStack staff, LivingEntity caster, Object args) {
        world.func_217376_c((Entity)new UltimatumShotEntity(caster, this, 60));
    }

    @Override
    public boolean doEntityImpact(BaseEnergyShot shot, Entity target, LivingEntity shooter) {
        if (target instanceof LivingEntity && !EntityUtil.isImmuneToSpecialAttacks(target, shooter)) {
            Vec3d lookVec = shooter.func_70040_Z();
            double posX = shooter.func_226277_ct_() + lookVec.field_72450_a * 4.0;
            double posZ = shooter.func_226281_cx_() + lookVec.field_72449_c * 4.0;
            target.func_70080_a(posX, shooter.func_226278_cu_(), posZ, (shooter.field_70759_as + 180.0f) % 360.0f, 0.0f);
            target.func_70034_d((shooter.field_70759_as + 180.0f) % 360.0f);
            target.func_70634_a(posX, shooter.func_226278_cu_(), posZ);
            AoAScheduler.scheduleSyncronisedTask(new UltimatumStaffTask(shooter, (LivingEntity)target), 2);
            return true;
        }
        return false;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText(this, LocaleUtil.ItemDescriptionType.UNIQUE, 1, new String[0]));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.damage.specImmune", LocaleUtil.ItemDescriptionType.HARMFUL, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

