/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.sword;

import com.google.common.collect.Multimap;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.tslat.aoa3.capabilities.volatilestack.VolatileStackCapabilityProvider;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.config.AoAConfig;

public class BaseSword
extends SwordItem {
    protected final float dmg;
    protected final double speed;

    public BaseSword(IItemTier itemStats) {
        super(itemStats, 0, itemStats.func_200928_b(), new Item.Properties().func_200918_c(itemStats.func_200926_a()).func_200916_a(AoAItemGroups.SWORDS).addToolType(ToolType.get((String)"sword"), itemStats.func_200925_d()));
        this.dmg = itemStats.func_200929_c();
        this.speed = itemStats.func_200928_b();
    }

    public float func_200894_d() {
        return this.dmg * ((Boolean)AoAConfig.COMMON.hardcoreMode.get() != false ? 1.25f : 1.0f);
    }

    public double getAttackSpeed() {
        return this.speed;
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        VolatileStackCapabilityProvider.getOrDefault(stack, Direction.NORTH).setValue(player.func_184825_o(0.0f));
        return false;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.doMeleeEffect(stack, target, attacker, VolatileStackCapabilityProvider.getOrDefault(stack, Direction.NORTH).getValue());
        return super.func_77644_a(stack, target, attacker);
    }

    protected void doMeleeEffect(ItemStack stack, LivingEntity target, LivingEntity attacker, float attackCooldown) {
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new VolatileStackCapabilityProvider();
    }

    public Multimap<String, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.func_200894_d(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", this.getAttackSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

