/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.sword;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.tslat.aoa3.capabilities.persistentstack.PersistentStackCapabilityHandles;
import net.tslat.aoa3.capabilities.persistentstack.PersistentStackCapabilityProvider;
import net.tslat.aoa3.common.registration.AoAItems;
import net.tslat.aoa3.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class GuardiansSword
extends BaseSword {
    public GuardiansSword() {
        super(ItemUtil.customItemTier(2050, -2.4f, 15.0f, 4, 10, null));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        PersistentStackCapabilityHandles cap = PersistentStackCapabilityProvider.getOrDefault(heldStack, null);
        if (cap.getValue() <= 0.0f && ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)AoAItems.CRYSTALLITE.get()), true, 1)) {
            cap.setValue(world.func_82737_E());
            if (world instanceof ServerWorld) {
                double xOffset = -MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 140.0f));
                double zOffset = MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 140.0f));
                ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197624_q, player.func_226277_ct_() + xOffset, player.func_226278_cu_() + (double)player.func_213302_cg() * 0.5, player.func_226281_cx_() + zOffset, 5, xOffset, 0.0, zOffset, 0.0);
            }
            return ActionResult.func_226248_a_((Object)heldStack);
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        PersistentStackCapabilityProvider.getOrDefault(stack, Direction.NORTH).setValue(player.func_184825_o(0.0f));
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        PersistentStackCapabilityHandles cap;
        if (world.func_82737_E() % 10L == 0L && (cap = PersistentStackCapabilityProvider.getOrDefault(stack, null)).getValue() > 0.0f && cap.getValue() < (float)(world.func_82737_E() - 2400L)) {
            cap.setValue(0.0f);
        }
    }

    @Override
    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        ItemUtil.damageItem(stack, attacker, 1, EquipmentSlotType.MAINHAND);
        return true;
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new PersistentStackCapabilityProvider(null);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap attributeMap = super.getAttributeModifiers(slot, stack);
        if (slot == EquipmentSlotType.MAINHAND) {
            int buff = 0;
            PersistentStackCapabilityHandles cap = PersistentStackCapabilityProvider.getOrDefault(stack, null);
            if (cap.getValue() > 0.0f) {
                buff = 5;
            }
            ItemUtil.setAttribute((Multimap<String, AttributeModifier>)attributeMap, SharedMonsterAttributes.field_111264_e, field_111210_e, this.func_200894_d() + (float)buff);
        }
        return attributeMap;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
    }
}

