/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.sword;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.capabilities.volatilestack.VolatileStackCapabilityHandles;
import net.tslat.aoa3.capabilities.volatilestack.VolatileStackCapabilityProvider;
import net.tslat.aoa3.item.weapon.sword.BaseSword;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;

public class PrimalSword
extends BaseSword {
    public PrimalSword() {
        super(ItemUtil.customItemTier(1960, -2.4f, 13.0f, 4, 10, null));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (world.func_82737_E() % 10L == 0L && entity instanceof LivingEntity) {
            VolatileStackCapabilityHandles cap = VolatileStackCapabilityProvider.getOrDefault(stack, null);
            if (isSelected) {
                float currentCalcBuff;
                float currentDamageMod = cap.getValue();
                if (currentDamageMod != (currentCalcBuff = this.getCurrentDamageBuff(entity))) {
                    ((LivingEntity)entity).func_110140_aT().func_111148_a(this.getAttributeModifiers(EquipmentSlotType.MAINHAND, stack));
                    cap.setValue(currentCalcBuff);
                    ((LivingEntity)entity).func_110140_aT().func_111147_b(this.getAttributeModifiers(EquipmentSlotType.MAINHAND, stack));
                }
            } else if (cap.getValue() != 0.0f) {
                ((LivingEntity)entity).func_110140_aT().func_111148_a(this.getAttributeModifiers(EquipmentSlotType.MAINHAND, stack));
                cap.setValue(0.0f);
            }
        }
    }

    private float getCurrentDamageBuff(Entity holder) {
        if (holder instanceof LivingEntity) {
            float armour = (float)((LivingEntity)holder).func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e();
            if (armour > 15.0f) {
                return 15.0f / armour;
            }
            return 1.5f - armour / 30.0f;
        }
        return 1.0f;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap<String, AttributeModifier> modifierMap = super.func_111205_h(slot);
        if (slot == EquipmentSlotType.MAINHAND) {
            VolatileStackCapabilityHandles cap = VolatileStackCapabilityProvider.getOrDefault(stack, null);
            ItemUtil.setAttribute(modifierMap, SharedMonsterAttributes.field_111264_e, field_111210_e, this.func_200894_d() * (cap.getValue() == 0.0f ? 1.0f : cap.getValue()));
        }
        return modifierMap;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText((Item)this, LocaleUtil.ItemDescriptionType.BENEFICIAL, 1, new String[0]));
    }
}

