/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.thrown;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAEnchantments;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.entity.projectile.gun.BaseBullet;
import net.tslat.aoa3.entity.projectile.thrown.GooBallEntity;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.item.weapon.thrown.BaseThrownWeapon;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.EntityUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.PotionUtil;

public class GooBall
extends BaseThrownWeapon {
    public static final float dmg = 3.5f;

    public GooBall() {
        super(3.5, 7);
    }

    @Override
    @Nullable
    public SoundEvent getFiringSound() {
        return SoundEvents.field_187737_v;
    }

    @Override
    public BaseBullet findAndConsumeAmmo(PlayerEntity player, ItemStack weaponStack, Hand hand) {
        BaseGun item = (BaseGun)weaponStack.func_77973_b();
        if (ItemUtil.findInventoryItem(player, new ItemStack((IItemProvider)this), true, 1 + EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)AoAEnchantments.GREED.get()), (ItemStack)weaponStack))) {
            return new GooBallEntity((LivingEntity)player, item);
        }
        return null;
    }

    @Override
    public void doImpactDamage(Entity target, LivingEntity shooter, BaseBullet gooBall, float bulletDmgMultiplier) {
        if (target != null && DamageUtil.dealRangedDamage(target, shooter, (Entity)gooBall, 3.5f * bulletDmgMultiplier)) {
            EntityUtil.applyPotions(target, new PotionUtil.EffectBuilder(Effects.field_76421_d, 60).level(2));
            shooter.field_70170_p.func_184148_a(null, gooBall.func_226277_ct_(), gooBall.func_226278_cu_(), gooBall.func_226281_cx_(), (SoundEvent)AoASounds.GOO_BALL_IMPACT.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.damage.slow", LocaleUtil.ItemDescriptionType.BENEFICIAL, new String[0]));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

