/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.item.weapon.vulcane;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.AoAItemGroups;
import net.tslat.aoa3.common.registration.AoASounds;
import net.tslat.aoa3.util.DamageUtil;
import net.tslat.aoa3.util.ItemUtil;
import net.tslat.aoa3.util.LocaleUtil;
import net.tslat.aoa3.util.player.PlayerDataManager;
import net.tslat.aoa3.util.player.PlayerUtil;

public abstract class BaseVulcane
extends Item {
    protected double baseDmg;

    public BaseVulcane(double dmg, int durability) {
        super(new Item.Properties().func_200916_a(AoAItemGroups.VULCANES).func_200918_c(durability));
        this.baseDmg = dmg;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public double getDamage() {
        return this.baseDmg;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!(player instanceof ServerPlayerEntity)) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        PlayerDataManager plData = PlayerUtil.getAdventPlayer((ServerPlayerEntity)player);
        if (!plData.isRevengeActive()) {
            return ActionResult.func_226251_d_((Object)stack);
        }
        return this.activate(plData, stack, hand);
    }

    public ActionResult<ItemStack> activate(PlayerDataManager plData, ItemStack vulcane, Hand hand) {
        ServerPlayerEntity pl = plData.player();
        if (DamageUtil.dealVulcaneDamage(plData.getRevengeTarget(), (PlayerEntity)pl, (float)this.baseDmg)) {
            this.doAdditionalEffect(plData.getRevengeTarget(), (PlayerEntity)pl);
            pl.field_70170_p.func_184148_a(null, pl.func_226277_ct_(), pl.func_226278_cu_(), pl.func_226281_cx_(), (SoundEvent)AoASounds.ITEM_VULCANE_USE.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            ItemUtil.damageItem(vulcane, (LivingEntity)pl, hand);
            plData.disableRevenge();
            return ActionResult.func_226248_a_((Object)vulcane);
        }
        return ActionResult.func_226251_d_((Object)vulcane);
    }

    public void doAdditionalEffect(LivingEntity target, PlayerEntity player) {
    }

    public int func_77619_b() {
        return 8;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(1, LocaleUtil.getFormattedItemDescriptionText("items.description.damage.true", LocaleUtil.ItemDescriptionType.ITEM_DAMAGE, Double.toString(this.baseDmg)));
        tooltip.add(LocaleUtil.getFormattedItemDescriptionText("items.description.vulcane.use", LocaleUtil.ItemDescriptionType.ITEM_TYPE_INFO, new String[0]));
    }
}

