/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.advancement.trigger;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.tslat.aoa3.util.constant.Skills;

public class AoALevelUpTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation triggerId = new ResourceLocation("aoa3", "level_up");
    private final HashMap<PlayerAdvancements, Listeners> listeners = new HashMap();

    public ResourceLocation func_192163_a() {
        return triggerId;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners playerListeners = this.listeners.get(playerAdvancements);
        if (playerListeners == null) {
            playerListeners = new Listeners(playerAdvancements);
            this.listeners.put(playerAdvancements, playerListeners);
        }
        playerListeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners playerListeners = this.listeners.get(playerAdvancements);
        if (playerListeners != null) {
            playerListeners.remove(listener);
            if (playerListeners.isEmpty()) {
                this.listeners.remove(playerAdvancements);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        Skills skill = json.has("skill") ? Skills.valueOf(JSONUtils.func_151200_h((JsonObject)json, (String)"skill").toUpperCase()) : null;
        int lvl = json.has("level") ? MathHelper.func_76125_a((int)JSONUtils.func_151203_m((JsonObject)json, (String)"level"), (int)1, (int)1000) : 0;
        return new Instance(skill, lvl);
    }

    public void trigger(ServerPlayerEntity player, Skills skill, int level) {
        Listeners playerListeners = this.listeners.get(player.func_192039_O());
        if (playerListeners != null) {
            playerListeners.trigger(skill, level);
        }
    }

    static class Listeners {
        private final PlayerAdvancements advancements;
        private final HashSet<ICriterionTrigger.Listener<Instance>> listeners = new HashSet();

        public Listeners(PlayerAdvancements playerAdvancements) {
            this.advancements = playerAdvancements;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(Skills skill, int lvl) {
            ArrayList<ICriterionTrigger.Listener<Instance>> list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(skill, lvl)) continue;
                if (list == null) {
                    list = new ArrayList<ICriterionTrigger.Listener<Instance>>();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener : list) {
                    listener.func_192159_a(this.advancements);
                }
            }
        }
    }

    public static class Instance
    extends CriterionInstance {
        @Nullable
        private final Skills skill;
        private final int level;

        public Instance(@Nullable Skills skill, int lvl) {
            super(triggerId);
            this.skill = skill;
            this.level = MathHelper.func_76125_a((int)lvl, (int)1, (int)1000);
        }

        public JsonElement func_200288_b() {
            JsonObject obj = new JsonObject();
            if (this.skill != null) {
                obj.addProperty("skill", this.skill.toString().toLowerCase());
            }
            if (this.level > 0) {
                obj.addProperty("level", (Number)this.level);
            }
            return obj;
        }

        public boolean test(Skills skill, int level) {
            return !(this.skill != null && this.skill != skill || this.level != 0 && level < this.level);
        }
    }
}

