/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.advancement.trigger;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.tslat.aoa3.util.constant.Skills;

public class AoAXpGainTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation triggerId = new ResourceLocation("aoa3", "gain_xp");
    private final HashMap<PlayerAdvancements, Listeners> listeners = new HashMap();

    public ResourceLocation func_192163_a() {
        return triggerId;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners playerListeners = this.listeners.get(playerAdvancements);
        if (playerListeners == null) {
            playerListeners = new Listeners(playerAdvancements);
            this.listeners.put(playerAdvancements, playerListeners);
        }
        playerListeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancements, ICriterionTrigger.Listener<Instance> listener) {
        Listeners playerListeners = this.listeners.get(playerAdvancements);
        if (playerListeners != null) {
            playerListeners.remove(listener);
            if (playerListeners.isEmpty()) {
                this.listeners.remove(playerAdvancements);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        Skills skill = json.has("skill") ? Skills.valueOf(JSONUtils.func_151200_h((JsonObject)json, (String)"skill").toUpperCase()) : null;
        int xp = json.has("xp") ? JSONUtils.func_151203_m((JsonObject)json, (String)"xp") : 0;
        return new Instance(skill, xp);
    }

    public void trigger(ServerPlayerEntity player, Skills skill, int level) {
        Listeners playerListeners = this.listeners.get(player.func_192039_O());
        if (playerListeners != null) {
            playerListeners.trigger(skill, level);
        }
    }

    static class Listeners {
        private final PlayerAdvancements advancements;
        private final HashSet<ICriterionTrigger.Listener<Instance>> listeners = new HashSet();

        public Listeners(PlayerAdvancements playerAdvancements) {
            this.advancements = playerAdvancements;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(Skills skill, int xp) {
            ArrayList<ICriterionTrigger.Listener<Instance>> list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(skill, xp)) continue;
                if (list == null) {
                    list = new ArrayList<ICriterionTrigger.Listener<Instance>>();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener : list) {
                    listener.func_192159_a(this.advancements);
                }
            }
        }
    }

    public static class Instance
    extends CriterionInstance {
        @Nullable
        private final Skills skill;
        private final int xp;

        public Instance(@Nullable Skills skill, int xp) {
            super(triggerId);
            this.skill = skill;
            this.xp = xp;
        }

        public boolean test(Skills skill, int xp) {
            return !(this.skill != null && this.skill != skill || this.xp != 0 && this.xp > xp);
        }
    }
}

