/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.ILootCondition;

public class HoldingItem
implements ILootCondition {
    private final LootContext.EntityTarget target;
    private final ItemPredicate predicate;
    @Nullable
    private final Hand hand;

    public HoldingItem(LootContext.EntityTarget target, ItemPredicate predicate, @Nullable Hand hand) {
        this.target = target;
        this.predicate = predicate;
        this.hand = hand;
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.func_216031_c(this.target.func_216029_a());
        if (entity instanceof LivingEntity) {
            if (this.hand != null) {
                return this.predicate.func_192493_a(((LivingEntity)entity).func_184586_b(this.hand));
            }
            for (ItemStack stack : entity.func_184214_aD()) {
                if (!this.predicate.func_192493_a(stack)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<HoldingItem> {
        public Serializer() {
            super(new ResourceLocation("aoa3", "holding_item"), HoldingItem.class);
        }

        public void serialize(JsonObject json, HoldingItem holdingItem, JsonSerializationContext jsonSerializationContext) {
            json.add("target", jsonSerializationContext.serialize((Object)holdingItem.target));
            json.add("predicate", holdingItem.predicate.func_200319_a());
            if (holdingItem.hand != null) {
                json.addProperty("hand", holdingItem.hand.toString().toLowerCase());
            }
        }

        public HoldingItem deserialize(JsonObject json, JsonDeserializationContext jsonDeserializationContext) {
            return new HoldingItem((LootContext.EntityTarget)JSONUtils.func_188174_a((JsonObject)json, (String)"target", (JsonDeserializationContext)jsonDeserializationContext, LootContext.EntityTarget.class), ItemPredicate.func_192492_a((JsonElement)json.get("predicate")), json.has("hand") ? Hand.valueOf((String)json.get("hand").getAsString().toUpperCase()) : null);
        }
    }
}

