/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.tslat.aoa3.util.constant.Skills;
import net.tslat.aoa3.util.player.PlayerUtil;

public class PlayerHasLevel
implements ILootCondition {
    private final Skills skill;
    private final int level;

    public PlayerHasLevel(Skills skill, int level) {
        this.skill = skill;
        this.level = level;
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.func_216031_c(LootParameters.field_216284_d);
        if (entity == null) {
            entity = (Entity)lootContext.func_216031_c(LootParameters.field_216281_a);
        }
        return entity instanceof ServerPlayerEntity && PlayerUtil.doesPlayerHaveLevel((ServerPlayerEntity)entity, this.skill, this.level);
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<PlayerHasLevel> {
        public Serializer() {
            super(new ResourceLocation("aoa3", "player_has_level"), PlayerHasLevel.class);
        }

        public void serialize(JsonObject json, PlayerHasLevel playerHasLevel, JsonSerializationContext jsonSerializationContext) {
            json.addProperty("skill", playerHasLevel.skill.toString().toLowerCase());
            json.addProperty("level", (Number)playerHasLevel.level);
        }

        public PlayerHasLevel deserialize(JsonObject json, JsonDeserializationContext jsonDeserializationContext) {
            return new PlayerHasLevel(Skills.valueOf(JSONUtils.func_151200_h((JsonObject)json, (String)"skill").toUpperCase()), JSONUtils.func_151203_m((JsonObject)json, (String)"level"));
        }
    }
}

