/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.loot.conditions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameter;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.tslat.aoa3.util.constant.Resources;
import net.tslat.aoa3.util.player.PlayerUtil;

public class PlayerHasResource
implements ILootCondition {
    private final Resources resource;
    private final float amount;
    private boolean consume;

    public PlayerHasResource(Resources resource, float amount, boolean consume) {
        this.resource = resource;
        this.amount = amount;
        this.consume = consume;
    }

    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of((Object)LootParameters.field_216284_d);
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.func_216031_c(LootParameters.field_216284_d);
        if (entity == null) {
            entity = (Entity)lootContext.func_216031_c(LootParameters.field_216281_a);
        }
        if (entity instanceof ServerPlayerEntity) {
            return this.consume ? PlayerUtil.consumeResource((ServerPlayerEntity)entity, this.resource, this.amount, false) : PlayerUtil.getAdventPlayer((ServerPlayerEntity)entity).stats().getResourceValue(this.resource) >= this.amount;
        }
        return false;
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<PlayerHasResource> {
        public Serializer() {
            super(new ResourceLocation("aoa3", "player_has_resource"), PlayerHasResource.class);
        }

        public void serialize(JsonObject json, PlayerHasResource playerHasResource, JsonSerializationContext jsonSerializationContext) {
            json.addProperty("resource", playerHasResource.resource.toString().toLowerCase());
            json.addProperty("amount", (Number)Float.valueOf(playerHasResource.amount));
            json.addProperty("consume", Boolean.valueOf(playerHasResource.consume));
        }

        public PlayerHasResource deserialize(JsonObject json, JsonDeserializationContext jsonDeserializationContext) {
            return new PlayerHasResource(Resources.valueOf(JSONUtils.func_151200_h((JsonObject)json, (String)"resource").toUpperCase()), JSONUtils.func_151217_k((JsonObject)json, (String)"amount"), JSONUtils.func_151204_g((JsonObject)json, (String)"consume") && JSONUtils.func_151212_i((JsonObject)json, (String)"consume"));
        }
    }
}

