/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.loot.conditions;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameter;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.tslat.aoa3.util.constant.Deities;
import net.tslat.aoa3.util.player.PlayerUtil;

public class PlayerHasTribute
implements ILootCondition {
    private final Deities deity;
    private final int amount;

    public PlayerHasTribute(Deities deity, int amount) {
        this.deity = deity;
        this.amount = amount;
    }

    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of((Object)LootParameters.field_216284_d);
    }

    public boolean test(LootContext lootContext) {
        Entity entity = (Entity)lootContext.func_216031_c(LootParameters.field_216284_d);
        if (entity == null) {
            entity = (Entity)lootContext.func_216031_c(LootParameters.field_216281_a);
        }
        if (entity instanceof ServerPlayerEntity) {
            return PlayerUtil.getAdventPlayer((ServerPlayerEntity)entity).stats().getTribute(this.deity) >= this.amount;
        }
        return false;
    }

    public static class Serializer
    extends ILootCondition.AbstractSerializer<PlayerHasTribute> {
        public Serializer() {
            super(new ResourceLocation("aoa3", "player_has_tribute"), PlayerHasTribute.class);
        }

        public void serialize(JsonObject json, PlayerHasTribute playerHasTribute, JsonSerializationContext jsonSerializationContext) {
            json.addProperty("deity", playerHasTribute.deity.toString().toLowerCase());
            json.addProperty("amount", (Number)playerHasTribute.amount);
        }

        public PlayerHasTribute deserialize(JsonObject json, JsonDeserializationContext jsonDeserializationContext) {
            return new PlayerHasTribute(Deities.valueOf(JSONUtils.func_151200_h((JsonObject)json, (String)"deity").toUpperCase()), JSONUtils.func_151203_m((JsonObject)json, (String)"amount"));
        }
    }
}

