/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.library.loot.functions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootFunction;
import net.minecraft.world.storage.loot.conditions.ILootCondition;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.aoa3.advent.Logging;
import org.apache.logging.log4j.Level;

public class EnchantSpecific
extends LootFunction {
    private final HashMap<Enchantment, Integer> enchants;

    protected EnchantSpecific(ILootCondition[] lootConditions, List<EnchantmentData> enchantments) {
        super(lootConditions);
        this.enchants = new HashMap(enchantments.size());
        for (EnchantmentData ench : enchantments) {
            this.enchants.put(ench.field_76302_b, ench.field_76303_c);
        }
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        EnchantmentHelper.func_82782_a(this.enchants, (ItemStack)stack);
        return stack;
    }

    public static LootFunction.Builder<?> builder(EnchantmentData ... enchantments) {
        return EnchantSpecific.func_215860_a(conditions -> new EnchantSpecific((ILootCondition[])conditions, Arrays.asList(enchantments)));
    }

    public static class Serializer
    extends LootFunction.Serializer<EnchantSpecific> {
        public Serializer() {
            super(new ResourceLocation("aoa3", "enchant_specific"), EnchantSpecific.class);
        }

        public void serialize(JsonObject object, EnchantSpecific function, JsonSerializationContext context) {
            super.func_186532_a(object, (LootFunction)function, context);
            JsonArray enchantments = new JsonArray();
            for (Map.Entry enchantEntry : function.enchants.entrySet()) {
                JsonObject enchantObject = new JsonObject();
                enchantObject.addProperty("id", ((Enchantment)enchantEntry.getKey()).getRegistryName().toString());
                enchantObject.addProperty("level", (Number)enchantEntry.getValue());
                enchantments.add((JsonElement)enchantObject);
            }
            object.add("enchantments", (JsonElement)enchantments);
        }

        public EnchantSpecific deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditions) {
            JsonElement enchantmentsObject;
            ArrayList<EnchantmentData> enchants = new ArrayList<EnchantmentData>();
            if (object.has("enchantments") && (enchantmentsObject = object.get("enchantments")).isJsonArray()) {
                for (JsonElement element : enchantmentsObject.getAsJsonArray()) {
                    JsonObject enchantObject;
                    if (!element.isJsonObject() || !(enchantObject = element.getAsJsonObject()).has("id") || !enchantObject.has("level")) continue;
                    Enchantment enchant = null;
                    int level = 1;
                    try {
                        JsonElement levelElement;
                        JsonElement idElement = enchantObject.get("id");
                        if (idElement.isJsonPrimitive()) {
                            enchant = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(idElement.getAsJsonPrimitive().getAsString()));
                        }
                        if ((levelElement = enchantObject.get("level")).isJsonPrimitive()) {
                            level = levelElement.getAsJsonPrimitive().getAsInt();
                        }
                        enchants.add(new EnchantmentData(enchant, level));
                    }
                    catch (Exception ex) {
                        Logging.logMessage(Level.ERROR, "Invalid data type for enchant in EnchantSpecific deserialization, skipping entry");
                    }
                }
            }
            return new EnchantSpecific(conditions, enchants);
        }
    }
}

